<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the editor area.
 *
 * -------------------------------------------------------------------------
 */

?><div class="editor"
       data-name="project">
    <?php
        /**
         * -----------------------------------------------------------------
         *
         * Go through the project files currently open in the editor.
         *
         * -----------------------------------------------------------------
         */

        if ( $data = helperHasProject ( ) ) {
            $list = $app->projects->getFiles ( );
            $num = 0;
            foreach ( $list as $name => $editable ) {
                $num++;

                /**
                 * ---------------------------------------------------------
                 *
                 * Build an absolute file name and its relative URL.
                 *
                 * ---------------------------------------------------------
                 */

                $url  = helperGetStorage ( ) . $data[ 'dir' ] . '/' . $name;
                $file = mimimiBasePath ( $url, TRUE );

                /**
                 * ---------------------------------------------------------
                 *
                 * Later we will display the file's short name and its full
                 * name as the "title" attribute.
                 *
                 * ---------------------------------------------------------
                 */

                $attr  = '';
                $short = preg_replace ( '~^.*?([^/]+)$~u', '$1', $name );
                if ( $name != $short ) {
                    $attr = 'title="' . printValue ( $name, FALSE ) . '"';
                }

                /**
                 * ---------------------------------------------------------
                 *
                 * Display the file tab.
                 *
                 * ---------------------------------------------------------
                 */

                ?>
                <input name="project-file-selector"
                       id="project-file-<?php printValue ( $num ) ?>"
                       type="radio">

                <label class="tab"
                       draggable="true"
                       ondragstart="app.dragTab ( this )"
                       data-file="<?php printValue ( $name ) ?>"
                       <?php echo $attr ?>
                       for="project-file-<?php printValue ( $num ) ?>">
                    <?php printValue ( $short ) ?>
                </label>
                <?php

                /**
                 * ---------------------------------------------------------
                 *
                 * Display the file editing/vieweng area.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $editable ) {

                    ?>
                    <form class="file"
                          action="<?php printSiteUrl ( ) ?>menu/file/save/<?php printValue ( $name ) ?>"
                          onkeyup="app.submitByCtrlEnter ( this )"
                          method="post">

                        <textarea name="body"><?php
                            printValue (
                                @ file_get_contents ( $file )
                            )
                        ?></textarea>

                        <footer class="buttons">
                            <button class="btn" name="submit" type="submit" value="1">SAVE</button>
                        </footer>
                    </form>
                    <?php

                } else {
                    $pattern = '~^.*?\.(' . $app->projects->editorExtensions . '|'
                                          . $app->projects->viewerExtensions . ')$~ui';
                    if ( preg_match ( $pattern, $name ) ) {
                        $ext = preg_replace ( $pattern, '$1', $name );
                        switch ( mb_strtolower ( $ext, 'UTF-8' ) ) {

                            /**
                             * ---------------------------------------------
                             *
                             * For image files.
                             *
                             * ---------------------------------------------
                             */

                            case 'png':
                            case 'jpg':
                            case 'jpeg':
                            case 'gif':
                            case 'ico':
                            case 'webp':
                                 ?>
                                 <figure class="image">
                                     <img src="<?php printSiteUrl (      );
                                                     printValue   ( $url ) ?>" alt="" loading="lazy" decoding="async">
                                 </figure>
                                 <?php
                                 break;

                            /**
                             * ---------------------------------------------
                             *
                             * For audio files.
                             *
                             * ---------------------------------------------
                             */

                            case 'mp3':
                                 ?>
                                 <figure class="audio">
                                     <audio controls>
                                         <source src="<?php printSiteUrl (      );
                                                            printValue   ( $url ) ?>" type="audio/mpeg">
                                     </audio>
                                 </figure>
                                 <?php
                                 break;
                            case 'ogg':
                                 ?>
                                 <figure class="audio">
                                     <audio controls>
                                         <source src="<?php printSiteUrl (      );
                                                            printValue   ( $url ) ?>" type="audio/ogg">
                                     </audio>
                                 </figure>
                                 <?php
                                 break;
                            case 'wav':
                                 ?>
                                 <figure class="audio">
                                     <audio controls>
                                         <source src="<?php printSiteUrl (      );
                                                            printValue   ( $url ) ?>" type="audio/x-wav">
                                     </audio>
                                 </figure>
                                 <?php
                                 break;
                            case 'weba':
                                 ?>
                                 <figure class="audio">
                                     <audio controls>
                                         <source src="<?php printSiteUrl (      );
                                                            printValue   ( $url ) ?>" type="audio/webm">
                                     </audio>
                                 </figure>
                                 <?php
                                 break;

                            /**
                             * ---------------------------------------------
                             *
                             * For video files.
                             *
                             * ---------------------------------------------
                             */

                            case 'mp4':
                                 ?>
                                 <figure class="video">
                                     <video controls>
                                         <source src="<?php printSiteUrl (      );
                                                            printValue   ( $url ) ?>" type="video/mp4">
                                     </video>
                                 </figure>
                                 <?php
                                 break;
                            case 'webm':
                                 ?>
                                 <figure class="video">
                                     <video controls>
                                         <source src="<?php printSiteUrl (      );
                                                            printValue   ( $url ) ?>" type="video/webm">
                                     </video>
                                 </figure>
                                 <?php
                                 break;

                            /**
                             * ---------------------------------------------
                             *
                             * For font files.
                             *
                             * ---------------------------------------------
                             */

                            case 'otf':
                            case 'ttf':
                            case 'woff':
                            case 'woff2':
                                 ?>
                                 <figure class="font">
                                     <span>
                                         <?php printSiteUrl (      );
                                               printValue   ( $url ) ?>
                                     </span>
                                 </figure>
                                 <?php
                                 break;

                            /**
                             * ---------------------------------------------
                             *
                             * For other files.
                             *
                             * ---------------------------------------------
                             */

                        //  case 'tpl':
                        //  case 'php':
                        //  case 'htm':
                        //  case 'html':
                        //  case 'xml':
                        //  case 'css':
                        //  case 'js':
                        //  case 'json':
                        //  case 'txt':
                        //  case 'svg':
                            default:
                                 ?>
                                 <figure class="other">
                                     <span>
                                         <?php printSiteUrl (      );
                                               printValue   ( $url ) ?>
                                     </span>
                                 </figure>
                                 <?php
                        }
                    }
                }
            }
        }
    ?>
</div>