<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the toolbar icon "Memo".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiToolbarsMemo extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the toolbar icon "Memo".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the toolbar icon to compose its "url" field.
         * @return  array          ARRAY       to display this toolbar icon(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            return [ 'memo' => [ 'name'     => 'Tech Memo',
                                 'shortcut' => 'm',
                                 'inactive' => ! $this->app->checkForAdmin ( ),
                                 'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#5f6368"><path d="M280-400q17 0 28.5-11.5T320-440q0-17-11.5-28.5T280-480q-17 0-28.5 11.5T240-440q0 17 11.5 28.5T280-400Zm0-120q17 0 28.5-11.5T320-560q0-17-11.5-28.5T280-600q-17 0-28.5 11.5T240-560q0 17 11.5 28.5T280-520Zm0-120q17 0 28.5-11.5T320-680q0-17-11.5-28.5T280-720q-17 0-28.5 11.5T240-680q0 17 11.5 28.5T280-640Zm120 240h200v-80H400v80Zm0-120h320v-80H400v80Zm0-120h320v-80H400v80ZM80-80v-720q0-33 23.5-56.5T160-880h640q33 0 56.5 23.5T880-800v480q0 33-23.5 56.5T800-240H240L80-80Zm126-240h594v-480H160v525l46-45Zm-46 0v-480 480Z"/></svg>',
                                 'url'      => $base,
                                 'title'    => 'Opens notes you\'ve written to yourself while developing projects.' ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this toolbar icon.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the toolbar icon URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/toolbars/memo/UNEXPECTED-PARAMETERS
         *                                                           └────────┬──────────┘
         *                                                                    └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the toolbar icon URL contains unexpected parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return $params == ''
                            ? $this->app->render ( 'memo.tpl' )
                            : FALSE;
        }
    };
