<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module to request pages attached to the toolbar.
 *
 * -------------------------------------------------------------------------
 *
 * This module is very similar to the Menu module in design and operating
 * principle. There are only two differences. The first is that these
 * modules have different first segments of their URL. For example:
 *
 *     https://your.site/menu/something
 *     https://your.site/toolbars/something
 *
 * The second difference is the order of searching for the child module that
 * matches the requested page.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Collection.php', FALSE );

    class MyMimimiToolbars extends MyMimimiCollection {

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with the clicked URL.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $url  The URL that was clicked via the toolbar.
         * @return  bool          TRUE  if the page was rendered successfully.
         *                        FALSE if there is no associated module or operation.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $url = '' ) {
            $module = $url ? $this->findModule ( $url, 'run' )
                           : FALSE;
            return $module ? $module->run ( $url )
                           : FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages attached to the toolbar referenced by its URL.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $url  EMPTY STRING if you want to get a map for the toolbar.
         *                        STRING       if you need a map for the subtool referenced by the URL.
         * @return  array         Array of found map entries.
         *
         * -----------------------------------------------------------------
         */

        public function getMap ( $url = '' ) {
            $source = $url;
            $module = $url ? $this->findModule ( $url )
                           : $this;
            $baseUrl = 'toolbars/' . ( $module === $this
                                                 ? $source
                                                 : substr ( $source, 0, strlen ( $source ) - strlen ( $url ) ) );
            return $module ? $this->getMapFor ( $module, $baseUrl )
                           : [ ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Reset the namespace simulator. You should reset it because this
         * module may have child or more nested modules with functionality
         * related to their hierarchy.
         *
         * -----------------------------------------------------------------
         *
         * @var    string
         * @access protected
         *
         * -----------------------------------------------------------------
         */

        protected $myNodeFile = __FILE__;
    };
