<?php
/**
 * -------------------------------------------------------------------------
 * Class for the HAS module.
 *
 * It checks for the existence of other modules in the specific framework
 * folder.
 *
 * -------------------------------------------------------------------------
 *
 * Implemented methods below are:
 *     __get
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Core
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    CC BY 4
 *             https://www.creativecommons.org/licenses/by/4.0
 * -------------------------------------------------------------------------
 */

mimimiInclude('Module.php');
class MimimiHas extends MimimiModule {

    /**
     * ---------------------------------------------------------------------
     * Public method to check for the existence.
     *
     * @public
     * @param   string  $property  Name of the property.
     * @return  bool               True if such a module exists,
     *                             False if it's not present.
     * ---------------------------------------------------------------------
     */

    public function __get ( $property ) {
        return ! isset($this->$property)
               ? isset($this->owner->$property) &&
                 ! empty($this->owner->$property) ||
                 mimimiCreate($property, $this->owner, true)
               : false;
    }
};