<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a home page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     start session
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl' );

    startSession ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Do some security logic:
     *     remember that page HOME is passed
     *     ............. page STEP-1 is not passed
     *     ............. page STEP-2 is not passed
     *     ............. page STEP-3 is not passed
     *     ............. page STEP-4 is not passed
     *     send status "200 OK"
     *
     * ---------------------------------------------------------------------
     */

    setCheckpoint   ( 'home'  );
    clearCheckpoint ( 'step1' );
    clearCheckpoint ( 'step2' );
    clearCheckpoint ( 'step3' );
    clearCheckpoint ( 'step4' );

    sendStatus200 ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Simulate a post retrieved from the database.
     *
     * ---------------------------------------------------------------------
     */

    global  $post;
            $post = [
                'title' => 'Install the MiMiMi - Welcome',
                'meta'  => 'This is a welcome page of the framework installer.',
                'h1'    => 'Welcome to the Installer!'
            ];

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?>  <?php mimimiModule ( 'blocks/header.tpl' ) ?>
    <main>
        <h1><?php printPageH1 ( ) ?></h1>
        <p>It will allow you to go through the installation process and select the desired framework configuration. Installation consists of <strong>4</strong> steps:</p>
        <ul>
            <li>choosing the installation directory,</li>
            <li>choosing the frontend theme,</li>
            <li>choosing which modules to install,</li>
            <li>configuring database access.</li>
        </ul>
        <hr>
        <p>As a result, you will install the MiMiMi framework (version <em><?php printValue ( MIMIMI_CORE_VERSION ) ?></em>) on your website.</p>
        <blockquote class="iconized">
            <svg class="icon">
                <use xlink:href="#icon-info"></use>
            </svg>
            If you are a developer, please see the <em><?php printValue ( $folder ) ?>Application.php</em> file and its template <em><?php printValue ( $folder . $filename ) ?></em> to understand how this installer works.
        </blockquote>
        <nav>
            <a class="btn" href="<?php printSiteUri ( ) ?>step-1"> Next &raquo; </a>
        </nav>
    </main>
    <?php mimimiModule ( 'blocks/footer.tpl' ) ?>
