<?php
/**
 * -------------------------------------------------------------------------
 *
 * Submodule for working with the secondary table of the Newspaper module.
 *
 * -------------------------------------------------------------------------
 *
 * @license  GPL-2.0  https://opensource.org/license/gpl-2-0/
 * @author   MiMiMi Community
 *
 * -------------------------------------------------------------------------
 */

mimimiInclude('ModuleWithTable.php');
class MyMimimiNewspapersArticles extends MimimiModuleWithTable {

    /**
     * ---------------------------------------------------------------------
     *
     * Specify a name of the database table to store newspaper articles.
     *
     * ---------------------------------------------------------------------
     *
     * @access protected
     * @var    string
     *
     * ---------------------------------------------------------------------
     */

    protected $table = 'newspapers_articles';

    /**
     * ---------------------------------------------------------------------
     *
     * Define a database table structure.
     *
     * ---------------------------------------------------------------------
     *
     * @access protected
     * @var    array
     *
     * ---------------------------------------------------------------------
     */

    protected $tableFields = [
                  '`id`         BIGINT(20)     NOT NULL  AUTO_INCREMENT      COMMENT "unique article identifier"',
                  '`owner`      BIGINT(20)     NOT NULL                      COMMENT "identifier of the newspaper"',
                  '`order`      INT(11)        NOT NULL                      COMMENT "position of this articles when sorting within its newspaper"',
                  '`size`       VARCHAR(10)    NOT NULL                      COMMENT "CSS class for sizing this article"',
                  '`layout`     VARCHAR(15)    NOT NULL                      COMMENT "CSS class for layouting this article"',
                  '`decor`      VARCHAR(10)    NOT NULL  DEFAULT "no-decor"  COMMENT "CSS class for decorating this article"',
                  '`h1`         VARCHAR(150)   NOT NULL                      COMMENT "article title"',
                  '`text`       VARCHAR(8190)  NOT NULL                      COMMENT "article HTML body"',
                  '`image`      VARCHAR(255)   NOT NULL                      COMMENT "image link if it is attached"',
                  '`image_alt`  VARCHAR(255)   NOT NULL                      COMMENT "remark for the attached image"',
                  '`credits`    VARCHAR(255)   NOT NULL                      COMMENT "credits link if it is reposting"'
              ];

    /**
     * ---------------------------------------------------------------------
     *
     * Define a list of table keys to speed up the database operations
     * related to newspapers and attached articles.
     *
     * ---------------------------------------------------------------------
     *
     * @access protected
     * @var    array
     *
     * ---------------------------------------------------------------------
     */

    protected $tableKeys = [
                  'PRIMARY KEY (`id`)',
                  'KEY         (`owner`)',
                  'KEY         (`order`)'
              ];

    /**
     * ---------------------------------------------------------------------
     *
     * Retrieves attached articles by newspaper ID.
     *
     * ---------------------------------------------------------------------
     *
     * @public
     * @param   int         $id  Identifier of the newspaper you are looking for.
     * @return  array|bool       ARRAY on success. Each element is an array, like a row obtained from a database table.
     *                           FALSE on failure. This means no articles were found.
     *
     * ---------------------------------------------------------------------
     */

    public function getItems ( $id ) {

        // build a filter by ID and a sorter by position
        $filter = [
            't1.owner' => $id,
            'orderby'  => [
                't1.order' => 'asc'
            ]
        ];

        // find entries
        return $this->select( $filter, 0, 1000000000 );
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Checks if the same image is attached to another article.
     *
     * ---------------------------------------------------------------------
     *
     * @public
     * @param   string  $image     The URL of the image you want to test.
     * @param   int     $exceptId  (optional) The identifier of the article being ignored.
     * @return  bool               TRUE if a duplicate is found.
     *
     * ---------------------------------------------------------------------
     */

    public function hasDuplicate ( $image, $exceptId = 0 ) {

        // build a filter by image
        $filter = [
            't1.image' => $image
        ];

        // if an ignored ID is specified, supplement the filter
        if ( $exceptId ) {
            $filter[ '! t1.owner' ] = $exceptId;
        }

        // check for duplicate
        return $this->select( $filter ) != FALSE;
    }
};