<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering the "Error 404" page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $app = your application
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML();
    sendStatus404();
    sendHeaderExpires( 0 );
    sendHeaderLastModified();

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html class="error404" lang="<?php myPrintSetting( '404_language' ) ?>">
    <head>
        <base href="<?php printSiteUrl() ?>">
        <meta charset="UTF-8">
        <meta name="viewport"    content="width=device-width, initial-scale=1">

        <title>
            <?php myPrintSetting( '404_title' ) ?>
        </title>
        <meta name="description" content="<?php myPrintSetting( '404_meta' ) ?>">
        <meta name="robots"      content="noindex, nofollow">
        <link rel="canonical"    href="<?php printSiteUrl() ?>">

        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/fonts.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/reset.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/styles.css">
    </head>

    <body>
        <div class="page">
            <div class="wrapper">
                <div class="edition">
                    <?php myPrintSetting( '404_edition' ) ?>
                </div>

                <aside class="header">
                    <div class="wrapper">
                        <div class="number">
                            <?php myPrintSetting( '404_number' ) ?>
                        </div>
                        <div class="slogan">
                            <?php myPrintSetting( '404_slogan' ) ?>
                        </div>
                    </div>
                </aside>

                <div class="content">
                    <table class="list">
                        <tbody class="wrapper">
                            <tr class="row preamble">
                                <td class="cell name">
                                    <?php myPrintSetting( '404_meta' ) ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <?php
                    /**
                     * -----------------------------------------------------
                     *
                     * Generate administrative tools.
                     *
                     * -----------------------------------------------------
                     */

                    mimimiModule(
                        'snippets/tools.tpl'
                    );
                ?>

                <aside class="footer">
                    <div class="wrapper">
                        <div class="copyright">
                            <?php myPrintSetting( 'home_copyright' ) ?>
                        </div>
                        <a class="credits" href="https://mimimi.software/" rel="nofollow noopener noreferrer" tabindex="-1">
                            Powered by MiMiMi
                        </a>
                    </div>
                </aside>
            </div>

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Generate some pointers to website pages.
                 *
                 * ---------------------------------------------------------
                 */

                mimimiModule(
                    'snippets/signpost.tpl'
                );
            ?>
        </div>

        <script src="<?php printThemeUrl() ?>js/scripts.js"></script>
    </body>
</html>