<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the newspapers list.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $app         = your application
 *     $params[ 0 ] = preamble text
 *     $params[ 1 ] = incoming list of newspapers to read
 *
 * -------------------------------------------------------------------------
 */

?>  <table class="list newspapers">
        <tbody class="wrapper">
            <?php

                /**
                 * ---------------------------------------------------------
                 *
                 * If the preamble text is not empty.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $params[ 0 ] ) {
                    ?>
                    <tr class="row preamble">
                        <td class="cell name" colspan="3">
                            <?php printValue( $params[ 0 ] ) ?>
                        </td>
                    </tr>
                    <?php
                }

                /**
                 * ---------------------------------------------------------
                 *
                 * If the incoming list of newspapers is not empty.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $params[ 1 ] ) {
                    $num = 0;
                    foreach ( $params[ 1 ] as $row ) {
                        $num++;
                        ?>
                        <tr class="row newspaper">
                            <td class="cell index">
                                <?php printValue( $num ) ?>.
                            </td>

                            <td class="cell name">
                                <a class="goto" href="<?php printValue( $row[ 'url'     ] ) ?>">
                                    <?php                   printValue( $row[ 'edition' ] ) ?>
                                </a>
                                <span class="number"><?php  printValue( $row[ 'number'  ] ) ?></span>
                                <span class="slogan"><?php  printValue( $row[ 'slogan'  ] ) ?></span>
                                <p    class="info"  ><?php  printValue( $row[ 'meta'    ] ) ?></p>
                            </td>

                            <td class="cell date" data-moderating="<?php myPrintModerating( $row ) ?>">
                                <?php myPrintDate( $row[ 'date' ] ) ?>
                            </td>
                        </tr>
                        <?php
                    }
                }
            ?>
        </tbody>
    </table>
