<?php
/**
 * -------------------------------------------------------------------------
 *
 * The module for working with page fragments.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'DatabaseModule.php', FALSE );

    class MyMimimiDatabaseFragments extends MimimiDatabaseModule {

        /**
         * -----------------------------------------------------------------
         *
         * Returns the extension used for every Fragment file in "database".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  string
         *
         * -----------------------------------------------------------------
         */

        public function getStorageExtension ( ) {
            return 'tpl';
        }

        /**
         * -----------------------------------------------------------------
         *
         * Returns the "database" path to store Fragment files as a TPL files.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  string
         *
         * -----------------------------------------------------------------
         */

        public function getStoragePath ( ) {
            return MIMIMI_APP_FOLDER . 'Themes/' . MIMIMI_APP_THEME . '/fragments/';
        }
    };
