<?php
/**
 * -------------------------------------------------------------------------
 *
 * The module for working with site pages.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'DatabaseModule.php', FALSE );

    class MyMimimiDatabasePages extends MimimiDatabaseModule {

        /**
         * -----------------------------------------------------------------
         *
         * Returns the extension used for every static page file in "database".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  string
         *
         * -----------------------------------------------------------------
         */

        public function getStorageExtension ( ) {
            return 'tpl';
        }

        /**
         * -----------------------------------------------------------------
         *
         * Returns the "database" path to store static pages as a TPL files.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  string
         *
         * -----------------------------------------------------------------
         */

        public function getStoragePath ( ) {
            return STATICPAGESONLY_STORAGE_SUBDIRECTORY;
        }
    };
