<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the Edit Style page.
 *
 * -------------------------------------------------------------------------
 *
 * Input parameters are:
 *
 *     $params = Text contents of this CSS file.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute server logic according to a form on this page.
     *
     * ---------------------------------------------------------------------
     */

    $success = '';
    $error   = '';

    /**
     * ---------------------------------------------------------------------
     *
     * Get the CSS entry that existed before a form was submitted.
     *
     * ---------------------------------------------------------------------
     */

    $item = [ 'url'  => helperGetCssUrl ( ) ,
              'body' => $params             ];

        /**
         * -----------------------------------------------------------------
         *
         * For the Copy page, we will have to forcefully change the URL.
         *
         * -----------------------------------------------------------------
         */

        if ( helperIsCopyUrl ( ) ) {
            $item[ 'url' ] = preg_replace ( '~(\.css)$~ui' ,
                                            '-copy$1'      ,
                                            $item[ 'url' ] );
        }

    /**
     * ---------------------------------------------------------------------
     *
     * If the admin has submitted a form with the CSS body.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'submit' ) ) {

        /**
         * -----------------------------------------------------------------
         *
         * Get all the fields of that form.
         *
         * -----------------------------------------------------------------
         */

        $entry = [ 'url'  => makeSecureUrl (
                                 getFormInput ( 'url' )
                             ) ,
                   'body' => helperGetFormCss ( 'body' ) ];

        /**
         * -----------------------------------------------------------------
         *
         * Now we check if the security timeout has expired. Note that we
         * have also set a new timeout period to ensure the safety of the
         * next action.
         *
         * -----------------------------------------------------------------
         */

        $expired = helperCheckForTimeout ( 'edit'                                   );
                   helperSetTimeout      ( 'edit', STATICPAGESONLY_TIMEOUT_FOR_EDIT );
        if ( $expired ) {

            /**
             * -------------------------------------------------------------
             *
             * After that, we must check the entered URL.
             *
             * -------------------------------------------------------------
             */

            if ( helperValidateCssUrl ( $entry[ 'url' ] ) ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * Check if the site works in production mode now.
                 *
                 * ---------------------------------------------------------
                 */

                if ( ! helperIsDemo ( ) ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * Make sure there are no conflicts due to an early
                     * requested URL being unexpectedly renamed by an admin.
                     *
                     * -----------------------------------------------------
                     */

                    $params = $item[ 'url' ] != $entry[ 'url' ] ? helperLoadCss ( $entry[ 'url' ] )
                                                                : '';
                    if ( $params == '' ) {

                        /**
                         * -------------------------------------------------
                         *
                         * Try to save this file and redirect the admin
                         * to the CSS Files page.
                         *
                         * -------------------------------------------------
                         */
 
                        helperSaveCss ( $entry[ 'url' ], $entry[ 'body' ] );
                        helperGotoPage ( 'styles' );

                    /**
                     * -----------------------------------------------------
                     *
                     * Otherwise, prepare an appropriate error message.
                     *
                     * -----------------------------------------------------
                     */

                    } else {
                        $error = 'You are trying to save a CSS file to another URL that is already taken! To do this, you need to edit the CSS using a direct link to its file.';
                    }
                } else {
                    $success = 'Everything is fine! However, you are currently in demo mode. Any saving is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
                }
            } else {
                $error = 'Please enter a valid URL! It can only contain Latin letters, numbers, hyphens, underscores and periods. It must start with a letter or number and may optionally have a nested path structure, where each path segment is separated by a slash. It also must not start with "styles/" and certain editor commands. It should also end with the extension ".css".';
            }
        } else {
            $error = 'Your previous attempts were too frequent! To avoid attacks on CSS files storage, the site uses a pause between critical actions (such as editing a CSS file). Try again in ' . STATICPAGESONLY_TIMEOUT_FOR_EDIT . ' seconds.';
        }

        /**
         * -----------------------------------------------------------------
         *
         * We will need to display the already edited file URL and its body
         * below, so we are using the ones obtained above from the submitted
         * form.
         *
         * -----------------------------------------------------------------
         */

        $item = $entry;
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         (   );
    sendStatus200          (   );
    sendHeaderExpires      ( 0 );
    sendHeaderLastModified (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            <?php        if ( helperIsAddUrl  ( ) ) { ?> Add a CSS file
            <?php } else if ( helperIsCopyUrl ( ) ) { ?> Copy a CSS file
            <?php } else                            { ?> Edit a CSS file
            <?php } ?>
        </title>

        <meta name="viewport"    content="width=device-width, initial-scale=1">
        <meta name="robots"      content="noindex, nofollow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/settings.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"><?php
                printValue ( $success )
            ?></header>

            <aside class="error"><?php
                printValue ( $error )
            ?></aside>

            <main class="content list">
                <div class="left">
                    <h1 class="title">
                        <?php        if ( helperIsAddUrl  ( ) ) { ?> Add Style
                        <?php } else if ( helperIsCopyUrl ( ) ) { ?> Copy Style
                        <?php } else                            { ?> Edit Style
                        <?php } ?>
                    </h1>
                    <p>Please edit the contents of this CSS file as you wish. If you have any questions, contact your web designer.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>styles" title="Return to the list of existing CSS files">
                        Cancel
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <label>
                            <span> File URL: </span>
                            <input name="url"
                                   type="text"
                                   maxlength="255"
                                   value="<?php printValue ( $item[ 'url' ] ) ?>"
                                   required
                                   tabindex="1">
                        </label>

                        <label>
                            <span> File Content: </span>
                            <textarea class="css"
                                      name="body"
                                      maxlength="262144"
                                      tabindex="2"><?php
                                printValue ( $item[ 'body' ] )
                            ?></textarea>
                        </label>

                        <button class="btn"
                                name="submit"
                                type="submit"
                                tabindex="3">
                            Save
                        </button>
                    </div>
                </div>
            </main>

            <footer class="footnote"></footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/settings.js"></script>
    </body>
</html>
