<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the Log In page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute server logic according to a form on this page.
     *
     * ---------------------------------------------------------------------
     */

    $error = '';
    $login = '';

    /**
     * ---------------------------------------------------------------------
     *
     * If the visitor has submitted a form with the entered login/password,
     * then first we must forcibly log him out. This action is necessary
     * to handle various situations, for example, when an admin is already
     * authorized and is just trying to log in again.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'submit' ) ) {
        helperLogoutAdmin ( );

        /**
         * -----------------------------------------------------------------
         *
         * Now we check if the security timeout has expired. Note that we
         * have also set a new timeout period to ensure the safety of the
         * next action.
         *
         * -----------------------------------------------------------------
         */

        $login = getFormInput ( 'login' );

        $expired = helperCheckForTimeout ( 'login'                                    );
                   helperSetTimeout      ( 'login', STATICPAGESONLY_TIMEOUT_FOR_LOGIN );
        if ( $expired ) {

            /**
             * -------------------------------------------------------------
             *
             * After that, we must get the entered login and check it.
             *
             * -------------------------------------------------------------
             */

            if ( helperValidateLogin ( $login ) ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * Then we must get the password entered by the visitor and
                 * check it in a similar manner.
                 *
                 * ---------------------------------------------------------
                 */

                $pass = mimimiPost ( 'pass' );
                if ( helperValidatePassword ( $login, $pass ) ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * Try to authorize this visitor as an admin and redirect
                     * him to the home page.
                     *
                     * -----------------------------------------------------
                     */

                    helperLoginAdmin ( );
                    helperSetTimeout ( 'delete',   0 );
                    helperSetTimeout ( 'edit',     0 );
                    helperSetTimeout ( 'settings', 0 );
                    helperGotoHome ( );

                } else {
                    $error = 'Sorry, this login or password is not valid!';
                }
            } else {
                $error = 'Please enter a valid login!';
            }
        } else {
            $error = 'Your previous attempts were too frequent! To avoid password guessing, the site uses a pause between authorizations. Try again in ' . STATICPAGESONLY_TIMEOUT_FOR_LOGIN . ' seconds.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Is the current visitor an administrator? We get this boolean flag
     * exactly before generating the page content because the helperAmIAdmin()
     * routine algorithm implies sending server headers that can no longer
     * be sent if this routine is used inside content generation.
     *
     * ---------------------------------------------------------------------
     */

    $amIAdmin = helperAmIAdmin ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         ( );
    sendStatus200          ( );
    sendHeaderLastModified ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     *
     * Please note that the input form below is protected by a <div> tag
     * instead of the classic <form> tag. Additionally, its submit button is
     * protected by removing the "value=1" attribute. Automatic removal of
     * protection is performed by calling the secureForm() function
     * implemented in the "static.pages.only/Themes/default/js/login.js"
     * file.
     *
     * This trivial protection allows you to protect the site from many spam
     * bots that try to send any form found on your site.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Log In
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex, nofollow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/login.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"><?php
                if ( $amIAdmin ) {
                    ?>
                    You are already logged in. <br>
                    Any attempt to log in again will close your current session.
                    <?php
                }
            ?></header>

            <aside class="error"><?php
                printValue ( $error )
            ?></aside>

            <main class="content">
                <div class="left">
                    <h1 class="title">
                        Log In
                    </h1>
                    <p>Authorization will grant editing rights to our administrators. Regular visitors do not need to log in.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>" title="Return to the home page">
                        Cancel
                    </a>
                </div>

                <div class="right">
                    <svg viewBox="0 0 320 300">
                        <defs>
                            <linearGradient inkscape:collect="always"
                                            id="linearGradient"
                                            x1="13"
                                            y1="193.49992"
                                            x2="307"
                                            y2="193.49992"
                                            gradientUnits="userSpaceOnUse">
                                <stop style="stop-color:#ff00ff;"
                                      offset="0"
                                      id="stop876" />
                                <stop style="stop-color:#ff0000;"
                                      offset="1"
                                      id="stop878" />
                            </linearGradient>
                        </defs>
                        <path d="m 40,120.00016 239.99984,-3.2e-4 c 0,0 24.99263,0.79932 25.00016,35.00016 0.008,34.20084 -25.00016,35 -25.00016,35 h -239.99984 c 0,-0.0205 -25,4.01348 -25,38.5 0,34.48652 25,38.5 25,38.5 h 215 c 0,0 20,-0.99604 20,-25 0,-24.00396 -20,-25 -20,-25 h -190 c 0,0 -20,1.71033 -20,25 0,24.00396 20,25 20,25 h 168.57143" />
                    </svg>

                    <div class="form">
                        <label>
                            Your Login:
                            <input name="login"
                                   type="text"
                                   maxlength="50"
                                   value="<?php printValue ( $login ) ?>"
                                   required
                                   tabindex="1">
                        </label>

                        <label>
                            Password:
                            <input name="pass"
                                   type="password"
                                   maxlength="100"
                                   value=""
                                   tabindex="2">
                        </label>

                        <button class="btn"
                                name="submit"
                                type="submit"
                                tabindex="3">
                            Submit
                        </button>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <a href="<?php printSiteUrl ( ) ?>credits" title="Gratitude to third party developers">
                    Credits
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/animejs-2.2.0.min.js"></script>
        <script src="<?php printThemeUrl ( ) ?>js/login.js"></script>
    </body>
</html>
