<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to render the "sitemap.xml" document.
 *
 * -------------------------------------------------------------------------
 *
 * Input parameters are:
 *
 *     $params = List of relative page URLs to print in the sitemap document.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this document.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderXML          (    );
    sendStatus200          (    );
    sendHeaderExpires      ( 24 );
    sendHeaderLastModified (    );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the document content.
     *
     * ---------------------------------------------------------------------
     */

?><?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <url>
        <loc>
            <?php printSiteUrl ( ) ?>
        </loc>
    </url>
    <?php
        if ( $params ) {
            foreach ( $params as $url ) {
                ?>
                <url>
                    <loc>
                        <?php
                            printSiteUrl (      );
                            printValue   ( $url );
                        ?>
                    </loc>
                </url>
                <?php
            }
        }
    ?>
</urlset>
