<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering a fragment list.
 *
 * -------------------------------------------------------------------------
 *
 * Input parameters are:
 *
 *     $params = It has two versions: [ TRUE, LIST ] = A tree-like list of collected fragment URLs provided for display with TEXTAREAs.
 *                                            LIST   = A tree-like list of collected fragment URLs provided for display.
 *
 * -------------------------------------------------------------------------
 */
    /**
     * ---------------------------------------------------------------------
     *
     * Define a local procedure to display administrative links.
     *
     * ---------------------------------------------------------------------
     */

    function localDisplayFragmentLinks ( $src, $default, $withTextarea = FALSE ) {
        $html = helperLoadFragment (        $src     );
        $name = helperGetName      ( $html, $default );
        ?>

        <a href="<?php printSiteUrl (                          );
                       printValue   ( 'fragments/edit/' . $src ) ?>" title="Edit this Fragment block" rel="nofollow">
            <?php printValue ( $name ) ?>
        </a>

        <?php
            if ( $name != $default ) {
                ?>
                <small>
                    <?php printValue ( $src ) ?>
                </small>
                <?php
            }
        ?>

        <small class="tools">
            &bullet; <a href="<?php printSiteUrl (                            );
                                    printValue   ( 'fragments/upload/' . $src ) ?>" title="Replace this Fragment block with a new one" rel="nofollow">
                         upload
                     </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                              );
                                                         printValue   ( 'fragments/download/' . $src ) ?>" title="Download this Fragment as a TPL file" rel="nofollow">
                                              download
                                          </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                          );
                                                                              printValue   ( 'fragments/copy/' . $src ) ?>" title="Clone this Fragment block" rel="nofollow">
                                                                   copy
                                                               </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                            );
                                                                                                   printValue   ( 'fragments/delete/' . $src ) ?>" title="Delete this Fragment block" rel="nofollow">
                                                                                        delete
                                                                                    </a>
        </small>

        <?php
            if ( $withTextarea ) {
                ?>
                <textarea name="dummy[]" disabled><?php
                    printValue ( $html )
                ?></textarea>
                <?php
            }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Define a local procedure to display the list of fragment URLs.
     *
     * ---------------------------------------------------------------------
     */

    function localDisplayFragmentList ( $list, $level = 0, $withTextarea = FALSE ) {
        $pattern = '~^.*?/([^/]+)$~us';
        ?>
        <ul>
            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Walk through the nodes of the fragment URLs.
                 *
                 * ---------------------------------------------------------
                 */

                foreach ( $list as $segment => & $url ) {
                    ?>
                    <li>
                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * If this segment is a node.
                             *
                             * ---------------------------------------------
                             */

                            if ( is_array ( $url ) ) {

                                /**
                                 * -----------------------------------------
                                 *
                                 * If the list contains both a file and
                                 * a directory node with the same name.
                                 *
                                 * -----------------------------------------
                                 */

                                if ( isset ( $url[ '' ] ) ) {
                                    $default = preg_replace ( $pattern, '$1', $url[ '' ] );
                                    localDisplayFragmentLinks ( $url[ '' ], $default, $withTextarea );
                                    unset ( $url[ '' ] );

                                /**
                                 * -----------------------------------------
                                 *
                                 * If it doesn't have a fragment with the
                                 * same name.
                                 *
                                 * -----------------------------------------
                                 */

                                } else {
                                    ?>
                                    <span>
                                        <?php printValue ( $segment ) ?>
                                    </span>
                                    <?php
                                }

                                /**
                                 * -----------------------------------------
                                 *
                                 * Display the subnodes of this branch.
                                 *
                                 * -----------------------------------------
                                 */

                                if ( $url ) {
                                    localDisplayFragmentList ( $url, $level + 1, $withTextarea );
                                }

                            /**
                             * ---------------------------------------------
                             *
                             * Otherwise, it is the end of the URL branch.
                             *
                             * ---------------------------------------------
                             */

                            } else {
                                $src = $level ? $url
                                              : $segment;
                                $default = preg_replace ( $pattern, '$1', $url );
                                localDisplayFragmentLinks ( $src, $default, $withTextarea );
                            }
                        ?>
                    </li>
                    <?php
                }
            ?>
        </ul>
        <?php
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Display collected fragments as a UL list.
     *
     * ---------------------------------------------------------------------
     */

    if ( ! empty ( $params ) ) {
        if ( isset ( $params[ 0 ] )
        &&           $params[ 0 ] === TRUE ) {
            localDisplayFragmentList ( $params[ 1 ], 0, TRUE );
        } else {
            localDisplayFragmentList ( $params               );
        }
    }
