<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering a page list.
 *
 * -------------------------------------------------------------------------
 *
 * Input parameters are:
 *
 *     $params = A tree-like list of collected page URLs provided for display.
 *
 * -------------------------------------------------------------------------
 */
    /**
     * ---------------------------------------------------------------------
     *
     * Define a local procedure to display administrative links.
     *
     * ---------------------------------------------------------------------
     */

    function localDisplayPageLinks ( $src, $default ) {
        $html = helperLoadPage (        $src     );
        $name = helperGetH1    ( $html, $default );
        ?>

        <a href="<?php printSiteUrl (      );
                       printValue   ( $src ) ?>" title="View this page">
            <?php printValue ( $name ) ?>
        </a>

        <small>
            <?php printValue ( $src ) ?>
        </small>

        <?php
        global $amIAdmin;
        if ( $amIAdmin ) {

            $permission       = helperGetPermission ( $html );
            $allowConstructor = $permission == '' || $permission == 'constructor';
            $allowEditor      = $permission == '' || $permission == 'editor';

            if ( $name != $default ) {
                ?>

                <small class="tools">
                    <?php
                        if ( $allowConstructor ) {
                            ?>
                            &bullet; <a href="<?php printSiteUrl (                     );
                                                    printValue   ( 'construct/' . $src ) ?>" title="Edit this page in the built-in Constructor" rel="nofollow">
                                         construct
                                     </a> &nbsp;
                            <?php
                        }

                        if ( $allowEditor ) {
                            ?>
                            &bullet; <a href="<?php printSiteUrl (                );
                                                    printValue   ( 'edit/' . $src ) ?>" title="Edit this page in the built-in HTML editor">
                                         edit
                                     </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                );
                                                                         printValue   ( 'copy/' . $src ) ?>" title="Clone this page using the built-in HTML editor" rel="nofollow">
                                                              copy
                                                          </a> &nbsp;
                            <?php
                        }
                    ?>

                    &bullet; <a href="<?php printSiteUrl (                  );
                                            printValue   ( 'markup/' . $src ) ?>" title="Edit this page as HTML code" rel="nofollow">
                                 mark up
                             </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                  );
                                                                 printValue   ( 'upload/' . $src ) ?>" title="Replace this page with a new one" rel="nofollow">
                                                      upload
                                                  </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                    );
                                                                                      printValue   ( 'download/' . $src ) ?>" title="Download this page as a TPL file" rel="nofollow">
                                                                           download
                                                                       </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                  );
                                                                                                           printValue   ( 'delete/' . $src ) ?>" title="Delete this page" rel="nofollow">
                                                                                                delete
                                                                                            </a>
                </small>
                <?php
            } else {
                ?>

                <small class="tools">
                    <?php
                        if ( $allowConstructor ) {
                            ?>
                            &bullet; <a href="<?php printSiteUrl (                     );
                                                    printValue   ( 'construct/' . $src ) ?>" title="Add this page using the built-in Constructor" rel="nofollow">
                                         construct
                                     </a> &nbsp;
                            <?php
                        }

                        if ( $allowEditor ) {
                            ?>
                            &bullet; <a href="<?php printSiteUrl (               );
                                                    printValue   ( 'add/' . $src ) ?>" title="Add this page using the built-in HTML editor">
                                         add
                                     </a> &nbsp;
                            <?php
                        }
                    ?>

                    &bullet; <a href="<?php printSiteUrl (                  );
                                            printValue   ( 'markup/' . $src ) ?>" title="Add this page using HTML code" rel="nofollow">
                                 mark up
                             </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                  );
                                                                 printValue   ( 'upload/' . $src ) ?>" title="Upload this page" rel="nofollow">
                                                      upload
                                                  </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                    );
                                                                                      printValue   ( 'download/' . $src ) ?>" title="Download this page as a TPL file" rel="nofollow">
                                                                           download
                                                                       </a>
                </small>
                <?php
            }
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Define a local procedure to display the list of page URLs.
     *
     * ---------------------------------------------------------------------
     */

    function localDisplayPageList ( $list, $level = 0 ) {
        $pattern = '~^.*?/([^/]+)$~us';
        ?>
        <ul>
            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Walk through the nodes of the page URLs.
                 *
                 * ---------------------------------------------------------
                 */

                foreach ( $list as $segment => & $url ) {
                    ?>
                    <li>
                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * If this segment is a node.
                             *
                             * ---------------------------------------------
                             */

                            if ( is_array ( $url ) ) {

                                /**
                                 * -----------------------------------------
                                 *
                                 * If the list contains both a file and
                                 * a directory node with the same name.
                                 *
                                 * -----------------------------------------
                                 */

                                if ( isset ( $url[ '' ] ) ) {
                                    $default = preg_replace ( $pattern, '$1', $url[ '' ] );
                                    localDisplayPageLinks ( $url[ '' ], $default );
                                    unset ( $url[ '' ] );

                                /**
                                 * -----------------------------------------
                                 *
                                 * If it doesn't have a page with the same
                                 * name.
                                 *
                                 * -----------------------------------------
                                 */

                                } else {
                                    ?>
                                    <span>
                                        <?php printValue ( $segment ) ?>
                                    </span>
                                    <?php
                                }

                                /**
                                 * -----------------------------------------
                                 *
                                 * Display the subnodes of this branch.
                                 *
                                 * -----------------------------------------
                                 */

                                if ( $url ) {
                                    localDisplayPageList ( $url, $level + 1 );
                                }

                            /**
                             * ---------------------------------------------
                             *
                             * Otherwise, it is the end of the URL branch.
                             *
                             * ---------------------------------------------
                             */

                            } else {
                                $src = $level ? $url
                                              : $segment;
                                $default = preg_replace ( $pattern, '$1', $url );
                                localDisplayPageLinks ( $src, $default );
                            }
                        ?>
                    </li>
                    <?php
                }
            ?>
        </ul>
        <?php
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Display collected pages as a UL list.
     *
     * ---------------------------------------------------------------------
     */

    localDisplayPageList ( $params );
