<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the News List page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = FALSE                                         ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = array of news listed on the current list page ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = number of the current list page               ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = 'news'                                        ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = ''                                            ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $app      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $okEdit = $app->amIAdmin();                         // am I admin? ( see file tiny.news.feed/Application.php -> amIAdmin )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderHTML();                                   // it is HTML document           ( see file mimimi.modules/Helper/Helper.php -> sendHeaderHTML )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(                                  // cache will expire             ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
        $okEdit ? 0                                     // . . immediately if user is an admin
                : 1                                     // . . otherwise after 1 hour
    );                                                  //
    sendHeaderLastModified();                           // last modified time equals now ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * HTML content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    global $page;                                       // refer to the incoming variable
                                                        // -----------------
    $row = [ 'h1'      => TINYFEED_NEWSLIST_H1,         // make a pseudo publication         ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSLIST_H1 )
             'title'   => TINYFEED_NEWSLIST_TITLE . $page, //  with this title + page number ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSLIST_TITLE )
             'meta'    => TINYFEED_NEWSLIST_META,       // . . with this short text          ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSLIST_META )
             'body'    => TRUE,                         // . . no full text
             'image'   => '',                           // . . no image
             'prefix'  => '',                           // . . no viewer segment
             'url'     => 'news',                       // . . canonical URL is the root of news list
             'enabled' => TRUE ];                       // . . for "index, follow" in the <meta> tag
                                                        // -----------------
?>
<!DOCTYPE html>
<html class="news list" lang="<?php printValue(TINYFEED_HTMLPAGE_LANGUAGE) ?>" dir="ltr">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/head.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/head.tpl )
            $row                                        // . . for this pseudo publication
        ]);                                             //
    ?>

    <!-- ---------------------------------------
    *                                          *
    * The website header.                      *
    *                                          *
    ---------------------------------------- -->

    <body>
        <?php                                           // -----------------
            mimimiModule([                              // render a snippet                   ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/header.tpl',                  // . . from this template             ( see file tiny.news.feed/Themes/default/snippets/header.tpl )
                TINYFEED_INTERFACE_BREADCRUMBS_LIST     // . . with this last breadcrumb node ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS_LIST )
                                  . ' ' . $page         //
            ]);                                         //
                                                        // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/form-search.tpl'              // . . from this template ( see file tiny.news.feed/Themes/default/snippets/form-search.tpl )
            );                                          //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The list of news cards.              *
        *                                      *
        ------------------------------------ -->

        <main class="content list">
            <?php                                       // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $row                                // . . for this pseudo publication
                ]);                                     //
                                                        // -----------------
                global $viewer;                         // refer to the incoming variable
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/list.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/list.tpl )
                    $viewer                             // . . for this viewer name
                ]);                                     //
            ?>
        </main>

        <!-- -----------------------------------
        *                                      *
        * Pagination and administrative tools. *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/pagination.tpl',              // . . from this template ( see file tiny.news.feed/Themes/default/snippets/pagination.tpl )
                $viewer                                 // . . for this viewer name
            ]);                                         //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The website footer.                  *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/footer.tpl'                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/footer.tpl )
            );                                          //
        ?>
    </body>
</html>