<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a home page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app = your application
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderHTML ( );
    sendStatus200  ( );
    stopIfHead     ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en-US">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/reset.min.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fonts.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">

        <meta name="robots" content="index, follow">
        <title>
            Welcome to Shopping UI with Vue.js!
        </title>
        <meta name="description" content="This web app is an example of how you can build a simple user interface with Vue.js.">
    </head>

    <body>
        <div class="wrapper">
            <div class="screen">
                <div class="app-bar">
                    &nbsp;
                </div>

                <h1 class="title">Hi there!</h1>

                <div class="shop-items">
                    <div class="item">
                        <div class="item-block">
                            <p class="description">Welcome to <b>Shopping UI with Vue.js</b> demo!</p>
                            <p class="description">This web application is an example of how you can build a simple user interface using <code>Vue.js</code> template without <code>Node.js</code> server-side rendering.</p>

                            <h2 class="name hr">Credits</h2>
                            <p class="description">Thanks to Morooka for his concept of <a href="https://codepen.io/mo-ro/pen/jObjGJm" rel="nofollow noopener noreferrer" target="_blank">Shopping UI</a>.</p>
                            <p class="description">Thanks to MiMiMi community for a small <a href="https://mimimi.software/" rel="nofollow noopener noreferrer" target="_blank">PHP framework</a>.</p>

                            <h2 class="name hr">What to see?</h2>
                            <p class="description">Now you can see a live demo for every page of this application.</p>
                            <p class="description">Let's start with the vendor pages. Here are two examples: <code>Nike Shoes</code> and <code>The Emptiness Wear</code>.</p>
                            <p class="description">The first one has 10 demo products to show. The second one doesn't have any products, so its button is grey (but you can still <a href="emptiness" rel="nofollow">view</a> its clear page).</p>
                            <?php
                                $list = $app->vendors->getVendors ( );
                                if ( $list ) {
                                    foreach ( $list as $entry ) {
                                        ?>
                                        <nav class="bottom-area" data-amount="<?php printValue ( $entry[ 'count' ] ) ?>">
                                            <div class="price">&nbsp;</div>
                                            <a class="button" href="<?php           printValue ( $entry[ 'url'   ] ) ?>">
                                                <p>SEE <?php                        printValue ( $entry[ 'brand' ] ) ?></p>
                                            </a>
                                        </nav>
                                        <?php
                                    }
                                }
                            ?>
                            <p class="description">If you are a webmaster, remember that this page is represented by a template file <code>Themes/default/vendor.tpl</code>.</p>
                            <p class="description">It is also associated with a module <code>Vendors/Vendors.php</code> to read a vendor entry from the database.</p>

                            <h2 class="name hr">SEO documents</h2>
                            <p class="description">This application also has the following URLs for crawlers.</p>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="robots.txt" rel="nofollow" target="_blank">
                                    <p>SEE ROBOTS.TXT</p>
                                </a>
                            </nav>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="sitemap.xml" rel="nofollow" target="_blank">
                                    <p>SEE SITEMAP.XML</p>
                                </a>
                            </nav>
                            <p class="description">If you do not understand the purpose of these documents, please ask your SEO specialist.</p>

                            <h2 class="name hr">Orders</h2>
                            <p class="description">This application has some pages with customer orders. Here are also two examples: <code>Order 1</code> and <code>Order 4</code>.</p>
                            <p class="description">The first one has 7 ordered products, its status is "Closed".</p>
                            <p class="description">Another one contains 2 ordered products, and its second line refers to a vendor <code>Lavager</code> that is no longer in the site's database.</p>
                            <?php
                                $list = $app->orders->getOrders ( );
                                if ( $list ) {
                                    foreach ( $list as $entry ) {
                                        ?>
                                        <nav class="bottom-area">
                                            <div class="price">
                                                $<?php printValue ( round ( $entry[ 'cost'  ], 2) ) ?>
                                                <small>
                                                    <?php      printValue ( $entry[ 'count' ] ) ?> items
                                                </small>
                                            </div>
                                            <a class="button small" href="order/<?php printValue ( $entry[ 'url'    ] ) ?>" rel="nofollow">
                                                <p>SEE ORDER <?php                    printValue ( $entry[ 'number' ] ) ?></p>
                                            </a>
                                        </nav>
                                        <?php
                                    }
                                }
                            ?>
                            <p class="description">Moreover, the last order was placed by an unregistered buyer <code>Young Visitor</code>, not by a registered buyer <code>Demo Customer</code>, as was the case with the first order.</p>

                            <h2 class="name hr">Technical pages</h2>
                            <p class="description">The first technical page is a cart endpoint. It can be visited only from the cart form.</p>
                            <p class="description">To understand this nuance, look at the template file <code>order-add.tpl</code>. You should also look at the cart form in template file <code>snippets/shopping-ui.vue</code>.</p>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="order/add" rel="nofollow">
                                    <p>ADD ORDER</p>
                                </a>
                            </nav>
                            <p class="description">The second technical page is a vendor endpoint. It is used to dynamically load vendor products in JSON format into the Vue template <code>shopping-ui.vue</code>.</p>
                            <p class="description">For more details, see a template file <code>order-json.tpl</code>.</p>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="nike/json" rel="nofollow" target="_blank">
                                    <p>SEE PRODUCTS JSON</p>
                                </a>
                            </nav>
                            <p class="description">The third technical page is a customer endpoint. It is used to dynamically load information about the current customer (if currently logged in) in JSON format into the cart form designed in Vue template <code>shopping-ui.vue</code>.</p>
                            <p class="description">For more details, see a template file <code>customer-json.tpl</code> and the associated module <code>Customers/Customers.php</code> for reading a customer entry.</p>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="customer/json" rel="nofollow" target="_blank">
                                    <p>SEE CUSTOMER JSON</p>
                                </a>
                            </nav>

                            <h2 class="name hr">Administrative pages</h2>
                            <p class="description">They are used to edit vendor pages.</p>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="add" rel="nofollow">
                                    <p>ADD VENDOR</p>
                                </a>
                            </nav>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="nike/delete" rel="nofollow">
                                    <p>DELETE VENDOR</p>
                                </a>
                            </nav>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="nike/edit" rel="nofollow">
                                    <p>EDIT VENDOR</p>
                                </a>
                            </nav>
                            <p class="description">Please remember that these pages are represented by template files <code>vendor-add.tpl</code>, <code>vendor-delete.tpl</code>, <code>vendor-edit.tpl</code>.</p>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="nike/add" rel="nofollow">
                                    <p>ADD VENDOR PRODUCT</p>
                                </a>
                            </nav>
                            <p class="description">Please remember that this page is represented by a template file <code>product-add.tpl</code>.</p>

                            <h2 class="name hr">Errors</h2>
                            <p class="description">Of course, there is a 404 error page.</p>
                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <a class="button small" href="abracadabra-or-missing-url" rel="nofollow">
                                    <p>SEE ERROR404</p>
                                </a>
                            </nav>
                            <p class="description">This page is represented by a template file <code>error404.tpl</code>.</p>

                            <h2 class="name hr">How to install?</h2>
                            <p class="description">You need to download MiMiMi installation package from the official website.</p>
                            <p class="description">Then you need to extract this package to your computer and copy all extracted files to your site.</p>
                            <p class="description">Open home page in a browser. You will see the initial page for installing MiMiMi package. Follow on-screen instructions. Once you reach the app variants page, select option <code>vue.js.cart</code>.</p>
                            <p class="description">This application requires two modules only. You must select them: <code>Helper</code> and <code>Db</code>.</p>
                            <p class="description">After installation, your site will work in demo mode. It prevents data from being saved to the database, but only simulates saving it. To switch the site to production mode, you should open file <code>Application.php</code> and change its property <code>$onProduction</code> to TRUE.</p>

                            <h2 class="name hr">How to remove demo details?</h2>
                            <p class="description">Once you have installed the application, remove directory <code>media/demo-posts</code> before opening the app's home page for the first time.</p>
                            <p class="description">Then you should remove a property <code>$demoRows</code> in all these files: <code>Customers/Customers.php</code>, <code>Orders/Orders.php</code>, <code>Vendors/Vendors.php</code>, <code>Vendors/Products/Products.php</code>.</p>
                            <p class="description">Then you should remove a method <code>install()</code> in the file <code>Vendors/Vendors.php</code>.</p>

                            <h2 class="name hr">What needs improvement?</h2>
                            <p class="description">This demo application does not have a login page. It always assumes that the current visitor is a logged in customer or administrator. So you need to improve the following details:</p>
                            <ol>
                                <li>Recode a method <code>Application.php</code> -&gt; <code>checkForAdmin()</code> to verify if the current visitor has an administrative role. Currently it always returns TRUE.</li>
                                <li>Recode a method <code>Application.php</code> -&gt; <code>getCustomerId()</code> to retrieve an identifier of the current customer. Currently it always returns 1 in demo mode and 0 in production.</li>
                                <li>Recode a method <code>Application.php</code> -&gt; <code>run()</code> to route a request to the login page and create a corresponding template file, such as <code>Themes/default/login.tpl</code>.</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>