<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering a vendor edit form.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $params = database entry retrieved by the "Vendors" module, it is an array consisting of these elements:
 *                   'id'     -->  system identifier
 *                   'lang'   -->  language attribute for page HTML tag, for example en-US
 *                   'url'    -->  page URL relative to the site URL,    for example hello-world
 *                   'brand'  -->  vendor name
 *                   'meta'   -->  text for meta description tag
 *                   'logo'   -->  logo URL relative to the site URL,    for example media/hello-world/logo-1.png
 *     $app    = your application
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute server logic according to this form.
     *
     * ---------------------------------------------------------------------
     */

    $error     = '';
    $success   = '';
    $languages = [ '', 'ar', 'hy', 'az', 'be', 'bg', 'en', 'en-US', 'et', 'fi', 'fr', 'ka', 'de', 'it', 'kk', 'ky', 'lv', 'lt', 'mo', 'no', 'pl', 'pt', 'ro', 'ru', 'sr', 'sk', 'sl', 'es', 'sv', 'tg', 'th', 'tr', 'tk', 'uk', 'uz' ];

    $entry     = $params;

    if ( getFormInput ( 'submit' ) ) {

        /**
         * -----------------------------------------------------------------
         *
         * Check for an attack based on the ID field.
         *
         * -----------------------------------------------------------------
         */

        $id = $params[ 'id' ];
        if ( getFormInput ( 'id' ) == $id ) {

            /**
             * -------------------------------------------------------------
             *
             * Get the entered form fields as an entry in the database.
             *
             * -------------------------------------------------------------
             */

            $entry = [
                'lang'  => getFormInput     ( 'lang'  ),
                'url'   => makeSecureUrl (
                               getFormInput ( 'url'   )
                           ),
                'brand' => getFormInput     ( 'brand' ),
                'meta'  => getFormInput     ( 'meta'  ),
                'logo'  => makeSecureUrl (
                               getFormInput ( 'logo'  ), FALSE
                           )
            ];

            /**
             * -------------------------------------------------------------
             *
             * The vendor name cannot be empty.
             *
             * -------------------------------------------------------------
             */

            if ( $entry[ 'brand' ] != '' ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * Validate the entered URL.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $entry[ 'url' ] == '' ) {
                    $entry[ 'url' ] = mimimiRandomId ( 4 ) . '-' .
                                      mimimiRandomId ( 4 ) . '-' .
                                      mimimiRandomId ( 4 ) . '-' .
                                      mimimiRandomId ( 4 );
                }

                if ( ! $app->vendors->getByUrl ( $entry[ 'url' ], $id ) ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * Save changes to the database.
                     *
                     * -----------------------------------------------------
                     */

                    if ( $app->onProduction ) {
                        $id ? $app->vendors->update ( $id, $entry )
                            : $app->vendors->add    (      $entry );

                        /**
                         * -------------------------------------------------
                         *
                         * Redirect to the vendor's page.
                         *
                         * -------------------------------------------------
                         */

                        $url = printSiteUrl ( FALSE ) . $entry[ 'url' ];
                        mimimiStop ( $url, 307 );

                    /**
                     * -----------------------------------------------------
                     *
                     * Otherwise, prepare an error message.
                     *
                     * -----------------------------------------------------
                     */

                    } else {
                        $success = 'Everything is fine! However, this website did not save your changes because you are currently in demo mode. In this mode, any addition/change/deletion of pages is simply simulated to show you how it would work on a real site.';
                    }
                } else {
                   $error = 'Unfortunately, another vendor already has the same URL. Please enter a different locator.';
                }
            } else {
               $error = 'The Vendor Name field is required.';
            }
            $entry[ 'id' ] = $id;
        } else {
            $error = 'Your request cannot be accepted because an attempt to spoof the ID field has been detected.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate form content.
     *
     * ---------------------------------------------------------------------
     */

?>  <p class="description error"><?php   printValue ( $error   ) ?></p>
    <p class="description success"><?php printValue ( $success ) ?></p>

    <legend>
        <small>Page URL Relative To Site URL:</small>
        <input type="text" name="url" value="<?php printValue ( $entry[ 'url' ] ) ?>" maxlength="255">
        <small>Leave this field blank if you want to automatically generate the page URL. In this case, it will consist of a random set of characters.</small>
    </legend>

    <legend>
        <small>Language Attribute For &lt;html&gt; Tag:</small>
        <select name="lang">
            <?php
                foreach ( $languages as $lang ) {
                    $attr  = $lang == $entry[ 'lang' ]
                                    ? ' selected'
                                    : '';
                    $label = $lang == ''
                                    ? '[none]'
                                    : $lang;
                    ?>
                    <option<?php         printValue ( $attr  ) ?>
                            vlaue="<?php printValue ( $lang  ) ?>">
                        <?php            printValue ( $label ) ?>
                    </option>
                    <?php
                }
            ?>
        </select>
        <small>To understand this attribute, please consult with your SEO specialist.</small>
    </legend>

    <legend>
        <small>Vendor Name:</small>
        <input type="text" name="brand" value="<?php printValue ( $entry[ 'brand' ] ) ?>" maxlength="60" required>
    </legend>

    <legend>
        <small>Text For &lt;meta&gt; Description Tag:</small>
        <input type="text" name="meta" value="<?php printValue ( $entry[ 'meta' ] ) ?>" maxlength="512">
        <small>To understand this tag, please consult with your SEO specialist.</small>
    </legend>

    <legend>
        <small>Logo URL Relative To Site URL:</small>
        <input type="text" name="logo" value="<?php printValue ( $entry[ 'logo' ] ) ?>" maxlength="255" pattern="((https?:)?//[\w\-][\w.\-]*?[\w\-]/)?([\w,.+\-][\w\/,.\+\-]*?[\w\-])?">
        <small>This is an icon shown in the upper left corner. For example <code>media/hello-world/logo-1.png</code>. Or if you want to use an absolute locator, enter it as <code>https://example.com/logo-1.png</code>, or as <code>//example.com/logo-1.png</code></small>
    </legend>

    <input type="hidden" name="id" value="<?php printValue ( $entry[ 'id' ] ) ?>">

    <div class="item">
        <div class="item-block">
            <nav class="bottom-area hr">
                <div class="price">&nbsp;</div>
                <button class="button" type="submit" name="submit" value="1">
                    <p>SAVE CHANGES</p>
                </button>
            </nav>
        </div>
    </div>
