<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a sitemap XML document.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app    = your application
 *     $params = entries listed by the "Channels" visual module
 *
 * -------------------------------------------------------------------------
 *
 * The first lines of this template pass the necessary headers to the user's
 * browser. To do this, routines such as "sendHeaderXML", "sendStatus200",
 * and "stopIfHead" are used. They are implemented in the "Helper" system
 * module. It is located in the "mimimi.modules/Helper/Helper.php" file.
 *
 * The next lines generate a document content. Two routines used here are
 * "printSiteUrl" and "printValue". They are also implemented in the "Helper"
 * module.
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderXML ( );
    sendStatus200 ( );
    stopIfHead    ( );

?><?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <?php
        if ( $params ) {
            foreach ( $params as $entry ) {
                ?>
                <url>
                    <loc>
                        <?php
                            printSiteUrl (                    );
                            printValue   ( $entry[ 'viewer' ] );
                            printValue   ( $entry[ 'url'    ] );
                        ?>
                    </loc>
                </url>
                <?php
            }
        }
    ?>
</urlset>
