<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the menu item "File -> Close Project".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiMenuFileClose extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the menu item "File -> Close Project".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            $activated = $this->app->menu->file->isActive ( );
            return [ 'close' => [ 'name'     => 'Close Project',
                                  'shortcut' => 'c',
                                  'inactive' => ! $activated,
                                  'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="m256-200-56-56 224-224-224-224 56-56 224 224 224-224 56 56-224 224 224 224-56 56-224-224-224 224Z"/></svg>',
                                  'url'      => $base,
                                  'title'    => 'Closes the current project.' ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/menu/file/close/UNEXPECTED-PARAMETERS
         *                                                             └────────┬──────────┘
         *                                                                      └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the menu item URL contains unexpected parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return $params == ''
                            ? $this->app->renderPage ( 'file/close.tpl' )
                            : FALSE;
        }
    };
