<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the menu item "File -> New".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiMenuFileNew extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the menu item "File -> New".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            $activated = $this->app->menu->file->isActive ( );
            return [ 'new' => [ 'name'     => 'New',
                                'title'    => 'Creates a new project or a new file within it.',

                                'subitems' => [ [ 'name'     => 'Project...',
                                                  'shortcut' => 'n',
                                                  'inactive' => $activated,
                                                  'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M560-320h80v-80h80v-80h-80v-80h-80v80h-80v80h80v80ZM160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h240l80 80h320q33 0 56.5 23.5T880-640v400q0 33-23.5 56.5T800-160H160Zm0-80h640v-400H447l-80-80H160v480Zm0 0v-480 480Z"/></svg>',
                                                  'url'      => $base,
                                                  'title'    => 'Creates a new project.' ],

                                                [ 'name'     => 'File...',
                                                  'inactive' => ! $activated,
                                                  'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h240v80H200v560h560v-240h80v240q0 33-23.5 56.5T760-120H200Zm440-400v-120H520v-80h120v-120h80v120h120v80H720v120h-80Z"/></svg>',
                                                  'url'      => $base . 'file',
                                                  'title'    => 'Creates a new file in the current project.' ] ] ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/menu/file/new/
         *                           https://your.site/menu/file/new/file
         *                           https://your.site/menu/file/new/UNEXPECTED-PARAMETERS
         *                                                           └────────┬──────────┘
         *                                                                    └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the menu item URL contains unexpected parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            switch ( $params ) {
                case '':     return $this->app->menu->file->isActive ( )
                                                              ? $this->app->renderNotAllowed ( )
                                                              : $this->app->renderPage ( 'file/new.tpl' );
                case 'file': return $this->app->menu->file->isActive ( )
                                                              ? $this->app->renderPage ( 'file/new-file.tpl' )
                                                              : $this->app->renderNotAllowed ( );
            }
            return FALSE;
        }
    };
