<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the menu item "File -> Save File".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiMenuFileSave extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the menu item "File -> Save File".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            $activated = $this->app->menu->file->isActive ( );
            return [ 'save' => [ 'name'     => 'Save File',
                                 'shortcut' => 's',
                                 'inactive' => ! $activated,
                                 'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M840-680v480q0 33-23.5 56.5T760-120H200q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h480l160 160Zm-80 34L646-760H200v560h560v-446ZM480-240q50 0 85-35t35-85q0-50-35-85t-85-35q-50 0-85 35t-35 85q0 50 35 85t85 35ZM240-560h360v-160H240v160Zm-40-86v446-560 114Z"/></svg>',
                                 'url'      => 'javascript: app.saveFile ( this )',
                                 'title'    => 'Saves changes made in the current file of your project.' ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/menu/file/save
         *                           https://your.site/menu/file/save/SOME-FILE-URL
         *                                                            └─────┬─────┘
         *                                                                  └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the menu item URL contains no parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            switch ( $params ) {
                case '': return FALSE;
                default: global $item;
                                $item = $params;
                         return $this->app->menu->file->isActive ( )
                                                          ? $this->app->renderPage ( 'file/save.tpl' )
                                                          : $this->app->renderNotAllowed ( );
            }
        }
    };
