<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Topmenu -> File -> Open -> Project".
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $error    = '';
    $screen   = 1;
    $projects = helperListProjects ( );

    /**
     * ---------------------------------------------------------------------
     *
     * If the input form was submitted.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'submit' ) ) {

        /**
         * -------------------------------------------------------------
         *
         * Get the selected directory name.
         *
         * -------------------------------------------------------------
         */

        $directory = getFormInput ( 'project' );
        if ( in_array ( $directory, $projects ) ) {
            helperOpenProject ( $directory );
            $screen = 2;

        /**
         * -----------------------------------------------------------------
         *
         * Otherwise, prepare an error message.
         *
         * -----------------------------------------------------------------
         */

        } else {
            $error = 'Sorry, there is no such project.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

    switch ( $screen ) {

        /**
         * -----------------------------------------------------------------
         *
         * On the first screen, we ask the user to enter file details.
         *
         * -----------------------------------------------------------------
         */

        case 1:
             ?>
             <form class="modal notification" action="<?php printPageUrl ( ) ?>" method="post">
                 <div class="error"  ><?php printValue ( $error ) ?></div>

                 <h1>Open Project</h1>
                 <p>Drag one or more files you need into the drop zone below. Or just click this zone to select files.</p>
                 <label>
                     <small>Project</small>
                     <select name="project">
                         <?php
                             foreach ( $projects as $directory ) {
                                 ?>
                                 <option>
                                     <?php printValue ( $directory ) ?>
                                 </option>
                                 <?php
                             }
                         ?>
                     </select>
                 </label>

                 <footer class="buttons">
                     <button class="btn" name="submit" type="submit" value="1">OPEN</button>
                     <button class="btn" onclick="app.closeWindow ( this )"   >CANCEL</button>
                 </footer>
             </form>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the second screen, we just save the name of the open project
         * in the browser session (local storage) and redirect the user to
         * the home page.
         *
         * Please note that this script runs before the page's main script
         * is loaded. That's why we don't use the "app.session" property and
         * its methods "setItem" and "removeItem" here.
         *
         * -----------------------------------------------------------------
         */

        case 2:
        default:
             ?>
             <script>
                 localStorage.setItem    ( 'project', '<?php printValue ( $directory ) ?>' );
                 localStorage.removeItem ( 'lastTab-project' );
                 localStorage.removeItem ( 'editor-project'  );
                 window.location.replace ( '<?php printSiteUrl ( ) ?>' )
             </script>
             <?php
    }
