<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Toolbars -> Memo".
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $databaseFile = preg_replace ( '~\.tpl$~ui', '', __FILE__ ) . '.txt';
    $success      = '';

    /**
     * ---------------------------------------------------------------------
     *
     * If the input form was submitted.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'submit' ) ) {

        /**
         * -------------------------------------------------------------
         *
         * Get the submitted memo.
         *
         * -------------------------------------------------------------
         */

        $notes = mimimiPost ( 'notes' );

        /**
         * -----------------------------------------------------------------
         *
         * Break HTML tags if there are any.
         *
         * -----------------------------------------------------------------
         */

        $bracketL = '(<|&lt;)';
        $bracketR = '(>|&gt;)';
        $char     = '([^\s])';

        $notes = preg_replace (
                     '~' . $bracketL . $char . '~ui',
                     '$1 $2',
                     preg_replace (
                         '~' . $char . $bracketR . '~ui',
                         '$1 $2',
                         $notes
                     )
                 );

        /**
         * -----------------------------------------------------------------
         *
         * Save memo to the database file.
         *
         * -----------------------------------------------------------------
         */

        if ( helperHasProduction ( ) ) {
            @ file_put_contents ( $databaseFile, $notes );

            /**
             * -------------------------------------------------------------
             *
             * Redirect the user to the home page.
             *
             * Please note that this script runs before the page's main
             * script is loaded. That's why we don't use the "app.session"
             * property and its method "removeItem" here.
             *
             * -------------------------------------------------------------
             */

            ?>
            <script>
                localStorage.removeItem ( 'lastTab-memo' );
                localStorage.removeItem ( 'editor-memo'  );
                window.location.replace ( '<?php printSiteUrl ( ) ?>' )
            </script>
            <?php
            return;

        /**
         * -----------------------------------------------------------------
         *
         * Otherwise, prepare an error message.
         *
         * -----------------------------------------------------------------
         */

        } else {
            $success = 'Sorry, you are currently in demo mode. Any create/add/edit/delete operation is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
        }

    /**
     * ---------------------------------------------------------------------
     *
     * Otherwise, read the previous memo from the database file.
     *
     * ---------------------------------------------------------------------
     */

    } else {
        $notes = @ file_get_contents ( $databaseFile );
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

?>  <div class="widgets"></div>

    <form class="editor"
          data-name="memo"
          action="<?php printPageUrl ( ) ?>"
          onkeyup="app.submitByCtrlEnter ( this )"
          method="post">

        <input id="memo-selector" type="radio" checked>

        <label class="tab"
               for="memo-selector"
               data-file="">
            Memo
        </label>

        <textarea name="notes"><?php printValue ( $notes ) ?></textarea>

        <div class="success"><?php printValue ( $success ) ?></div>

        <footer class="buttons">
            <button class="btn" name="submit" type="submit" value="1">SAVE</button>
        </footer>
    </form>
