<!DOCTYPE html>
<html lang="en">
    <head>
        <title>Taj Mahal: A breathtaking ode to love</title>
        <meta name="description" content="No trip to India is complete without visiting this spectacular monument, counted among the Seven Wonders of the World.">

        <!-- You can limit the list of allowed editing tools for this page to a specific name or any one (use an empty string) -->
        <meta name="editing-permission" content="editor">

        <!-- Note that this style URL must be specified relative to the "static.pages.only/Themes/css/pages" directory -->
        <link rel="stylesheet" href="ck-demo.css">
    </head>
    <body>
        <p>[insert=topmenu.tpl]</p>

        <article>
            <h2>Taj Mahal: A breathtaking ode to love</h2>

            <figure class="image image-style-side" height="400">
                <img src="media/demo-posts/static.pages.only/demo-pages/image-1.png"
                     loading="lazy"
                     alt="Taj Mahal illustration."
                     width="600"
                     height="386"/>
                <figcaption>Taj Mahal with its poetic white marble tomb</figcaption>
            </figure>

            <p>
                No trip to India is complete without visiting this spectacular monument,
                counted among the <a href="https://en.wikipedia.org/wiki/New7Wonders_of_the_World" rel="nofollow noopener noreferrer" target="_blank"><strong>Seven Wonders of the World</strong></a>.
            </p>

            <p>
                Tourists frequently admit that Taj Mahal "simply cannot be described
                with words". And that’s probably true. The more you try the more
                speechless you become. Words give only a semblance of truth. The real
                truth about its beauty is revealed when you adore
                <strong>different shades of “Taj” depending on the time of the day</strong>
                or when you admire the exquisite inlay work in different corners of
                the façade.
            </p>

            <h3>Masterpiece of the world’s heritage</h3>

            <p>
                Taj Mahal is a mausoleum built in Agra between 1631 and 1648 by
                Emperor Shah Jahan <strong>in the memory of his beloved wife</strong>,
                Mumtaz Mahal, whose body lies there. It took 20 000 workers to complete
                and the excellence of this building is visible in every brick.
            </p>

            <blockquote>
                <p>
                    In 1983, Taj Mahal was appointed
                    <a href="https://en.wikipedia.org/wiki/World_Heritage_Site" rel="nofollow noopener noreferrer" target="_blank">UNESCO World Heritage Site</a>
                    for being "the jewel of Muslim art in India and one of the universally
                    admired masterpieces of the world's heritage".
                </p>
            </blockquote>

            <p>
                If you like having a methodology for visiting historical places, here
                are the four elements on which we recommend to focus your attention:
            </p>

            <ul>
                <li>The tomb</li>
                <li>The decorations</li>
                <li>The garden</li>
                <li>The outlying buildings</li>
            </ul>

            <p>
                The tomb is what immediately catches your eyesight. The
                <strong>white and soft marble</strong>
                embroidered with stones leaves you totally enchanted.
            </p>
        <article>
    </body>
</html>
