<?php
/**
 * -------------------------------------------------------------------------
 *
 * The basis for a system module.
 *
 * -------------------------------------------------------------------------
 *
 * In the simplest case, the application being developed consists of two
 * layers. Such an application represents the imaginary first layer of
 * development. This app is a node for all callable modules, which are
 * the imaginary second layer.
 *
 * For example:
 *
 *     $someApp ─┬──> someModule1 ──> someMethod()
 *               ├──> someModule2 ──> someMethod()
 *               ├──> someModule3 ──> someMethod()
 *               └──> someModule4 ──> someMethod()
 *
 * These modules are derived from the MimimiModule class. And they are
 * each in their own subfolder, in the same place where the application
 * source file is located.
 *
 * -------------------------------------------------------------------------
 *
 * Look at this diagram to understand how the module works:
 *
 *     └─> mimimi.core/Module.php
 *                     │ └─> __construct()
 *                     │
 *                     ├─<─ property $owner
 *                     ├─<─ property $app
 *                     │
 *                     └─<─ method run()
 *
 * The right arrows show the order in which app files are loaded and their
 * methods that are called when processing a request to this module. The
 * left arrows show the class from which the corresponding application file
 * is derived. They also show some public routines, some public methods, or
 * some constants that the corresponding file exposes to other application
 * modules.
 *
 * -------------------------------------------------------------------------
 *
 * Implemented properties below are:
 *     $owner  -->  to link to the parent module
 *     $app    -->  to link to the main app module
 *
 * Implemented methods below are:
 *     __construct ( $owner  )  -->  to create a module instance
 *     run         ( $params )  -->  to launch this module
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Core
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 *
 * -------------------------------------------------------------------------
 */

    class MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Reference to the parent node.
         *
         * -----------------------------------------------------------------
         *
         * @var    object|false
         * @access public
         *
         * -----------------------------------------------------------------
         */

        public $owner = FALSE;

        /**
         * -----------------------------------------------------------------
         *
         * Reference to the application node (root module).
         *
         * -----------------------------------------------------------------
         *
         * @var    object|false
         * @access public
         *
         * -----------------------------------------------------------------
         */

        public $app = FALSE;

        /**
         * -----------------------------------------------------------------
         *
         * Creates an instance of this class.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   object|false  $owner  (optional) Reference to the parent module.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function __construct ( & $owner = FALSE ) {
            $this->owner = FALSE;
            $this->app   = FALSE;
            if ( is_object ( $owner ) ) {
                $this->owner = $owner;
                $this->app   = isset        ( $owner->app )
                               && is_object ( $owner->app )
                               ? $owner->app
                               : $owner;
            }
        }

        /**
         * -----------------------------------------------------------------
         *
         * Launches this module.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   mixed  $params  (optional) Some parameters from the calling process.
         * @return  mixed           Some results if you need.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return TRUE;
        }
    };
