<?php
/**
 * -------------------------------------------------------------------------
 *
 * Модуль контроллера "Вакансии".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Repost Vacancies
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Подключаем из папки ядра фреймворка файл "mimimi.core/Module.php".
     * Там объявлен класс "MimimiModule", являющийся простейшей модульной
     * заготовкой. Этот класс подходит как основа для реализуемого ниже
     * модуля.
     *
     * ---------------------------------------------------------------------
     */

    mimimiInclude ( 'Module.php' );

    /**
     * ---------------------------------------------------------------------
     *
     * Создаём на основе класса той заготовки новый класс, в котором напишем
     * программный код текущего модуля. Обратите внимание как задано имя
     * нового класса - оно сложено из имени класса вышестоящего модуля, то
     * есть "MyMimimiControllers", и имени текущего PHP-файла без расширения.
     *
     * ---------------------------------------------------------------------
     */

    class MyMimimiControllersVacancies extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Маршрутизировать запрос к сопоставленному макету шаблона.
         *
         * -----------------------------------------------------------------
         *
         * Этот метод обслуживает следующие URL-ы:
         *
         *     https://ваш.сайт/vacancies
         *     https://ваш.сайт/vacancies?page=ЧИСЛО
         *     https://ваш.сайт/vacancies?filter=ЗНАЧЕНИЕ
         *     https://ваш.сайт/vacancies?filter=ЗНАЧЕНИЕ&page=ЧИСЛО
         *     https://ваш.сайт/vacancies?item=ЧИСЛО
         *
         * Остальные URL-ы считаются Ошибкой 404, поэтому маршрутизируются
         * через метод renderError().
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $url  (необязательный) Относительный URL запрошенной страницы.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function run ( $url = '' ) {
            $this   ->renderPage  ( )
            || $this->renderList  ( )
            || $this->renderError ( );
        }

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Сгенерировать страницу конкретной вакансии.
         *
         * -----------------------------------------------------------------
         *
         * Этот метод обслуживает следующие URL-ы:
         *
         *     https://ваш.сайт/vacancies?item=ЧИСЛО
         *
         * Генерация HTML-кода страницы пройдёт на основе такого макета:
         *
         *     repost.vacancies/Themes/default/vacancy.tpl
         *
         * -----------------------------------------------------------------
         *
         * @protected
         * @return  bool  TRUE  если сгенерировано успешно.
         *                FALSE если этот запрос не относится к вакансии.
         *
         * -----------------------------------------------------------------
         */

        protected function renderPage ( ) {
            $id = $this->owner->getItemId ( FALSE );
            if ( $id !== '' ) {
                $this->app->models->vacancies->removeOld ( );
                $hasAdmin = $this->owner->dashboard->hasAdmin ( );
                $row      = $this->app->models->vacancies->findBy ( $id, $hasAdmin );
                if ( $row ) {
                    try {
                        $data = @ json_decode ( $row[ 'content' ], TRUE );
                    } catch ( Exception $e ) {
                        $data = FALSE;
                    }
                    if ( is_array ( $data ) ) {
                        $row[ 'content' ] = $data;
                        $this->app->views->html->run ([ 'vacancy.tpl', $row ]);
                        return TRUE;
                    }
                }
                return $this->renderError ( );
            }
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Сгенерировать страницу списка вакансий.
         *
         * -----------------------------------------------------------------
         *
         * Этот метод обслуживает следующие URL-ы:
         *
         *     https://ваш.сайт/vacancies
         *     https://ваш.сайт/vacancies?page=ЧИСЛО
         *     https://ваш.сайт/vacancies?filter=ЗНАЧЕНИЕ
         *     https://ваш.сайт/vacancies?filter=ЗНАЧЕНИЕ&page=ЧИСЛО
         *
         * Генерация HTML-кода страницы пройдёт на основе такого макета:
         *
         *     repost.vacancies/Themes/default/vacancies.tpl
         *
         * -----------------------------------------------------------------
         *
         * @protected
         * @return  bool  TRUE  если сгенерировано успешно.
         *                FALSE если этот запрос не относится к списку вакансий.
         *
         * -----------------------------------------------------------------
         */

        protected function renderList ( ) {
            $this->app->models->vacancies->removeOld ( );
            $hasAdmin = $this->owner->dashboard->hasAdmin ( );
            $id       = $this->owner->getFilter ( );
            $num      = $this->owner->getPageNum ( );
            $size     = 10;
            $rows     = $id === '' ? $this->app->models->vacancies->select   (      $num, $size, $hasAdmin )
                                   : $this->app->models->vacancies->selectBy ( $id, $num, $size, $hasAdmin );
            if ( $rows || $num == 1 ) {
                if ( $rows ) {
                    foreach ( $rows as $index => $row ) {
                        if ( $row ) {
                            try {
                                $data = @ json_decode ( $row[ 'content' ], TRUE );
                                if ( ! is_array ( $data ) ) {
                                    unset ( $rows[ $index ] );
                                    continue;
                                }
                                $rows[ $index ][ 'content' ] = $data;
                            } catch ( Exception $e ) { }
                        }
                    }
                }
                if ( $rows && count ( $rows ) || $num == 1 ) {
                    $task = $id === '' ? ''
                                       : $this->app->models->tasks->findBy ( $id );
                    $town = isset ( $task[ 'filter_name' ] ) ? $task[ 'filter_name' ]
                                                             : '';
                    $this->app->views->html->run ([ 'vacancies.tpl', [ 'pagenum' => $num  ,
                                                                       'filter'  => $id   ,
                                                                       'town'    => $town ,
                                                                       'rows'    => $rows ] ]);
                    return TRUE;
                }
            }
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Сгенерировать страницу "Ошибка 404".
         *
         * -----------------------------------------------------------------
         *
         * Генерация HTML-кода страницы пройдёт на основе такого макета:
         *
         *     repost.vacancies/Themes/default/page404.tpl
         *
         * -----------------------------------------------------------------
         *
         * @protected
         * @return  bool  Всегда TRUE. Это означает сгенерировано успешно.
         *
         * -----------------------------------------------------------------
         */

        protected function renderError ( ) {
            $this->owner->seo->run ( '404' );
            return TRUE;
        }
    }
