<!DOCTYPE html>
<html lang="ru-RU">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="noindex, nofollow">
        <title>Настройки сайта</title>
        <meta name="description" content="Редактирование настроек сайта.">
        <link rel="shortcut icon" href="<?php printThemeUrl () ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet" href="<?php printThemeUrl () ?>css/styles.css">
    </head>
    <body>
        <main class="form" action="settings">
            <h1>Настройки сайта</h1>
            <p>Отредактируйте их согласно Вашим задачам. Не сообщайте данные с этой страницы посторонним людям.</p>
            <p class="success"><?php printValue ( $params[ 'success' ] ) ?></p>
            <p class="error"><?php   printValue ( $params[ 'error'   ] ) ?></p>
            <?php
                $autofocus = 'autofocus';
                foreach ( $params[ 'rows' ] as $row ) {
                    if ( isDemo ( ) ) {
                        switch ( $row[ 'name' ] ) {
                            case 'tg_bot_token':
                            case 'max_bot_token':
                                 $row[ 'value' ] = preg_replace ( '~.~us', '*', $row[ 'value' ] );
                        }
                    }
                    ?>
                    <label>
                        <span><?php         printValue ( $row[ 'input_caption'    ] ) ?>:</span>
                        <input name="<?php  printValue ( $row[ 'name'             ] ) ?>"
                               value="<?php printValue ( $row[ 'value'            ] ) ?>"
                               type="<?php  printValue ( $row[ 'input_type'       ] ) ?>"
                               <?php        echo         $row[ 'input_attributes' ]   ?>
                               <?php        echo         $autofocus                   ?>>
                    </label>
                    <?php
                    $autofocus = '';
                }
            ?>
            <button name="<?php printValue ( $params[ 'button_name' ] ) ?>"
                    type="submit"
                    value="1">Сохранить</button>
            <a class="btn secondary" href="<?php printSiteUrl ( ) ?>">
                Отмена
            </a>
            <p>Если же Вы не хотите изменять настройки, нажмите кнопку "Отмена" для возрата на главную страницу.</p>
            <?php
                mimimiModule ( 'snippets/footer.tpl' );
