<!DOCTYPE html>
<html lang="ru-RU">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="index, follow">
        <title>Агрегатор вакансий региона</title>
        <meta name="description" content="Находитесь в поиске работы? На сайте собраны актуальные вакансии от работодателей Вашего региона.">
        <link rel="canonical" href="<?php printSiteUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet" href="<?php printThemeUrl ( ) ?>css/styles.css">
    </head>
    <body>
        <main>
            <h1>Агрегатор вакансий</h1>
            <?php
                mimimiModule ( 'snippets/demo-remark-1.tpl' );
            ?>
            <p>Находитесь в поиске работы? На этом сайте собраны актуальные вакансии от работодателей Вашего региона. Просто выберите интересующий город ниже. Вы увидите список действующих предложений на сегодня.</p>
            <p>Список вакансий обновляется ежедневно. Заходите к нам каждый день, пока не появится подходящая Вам работа.</p>
            <nav>
                <a class="btn secondary" href="vacancies">
                    Все
                </a>
                <?php
                    foreach ( $params as $row ) {
                        ?>
                        <a class="btn" href="vacancies?filter=<?php printValue ( $row[ 'filter_value' ] ) ?>">
                            <?php printValue ( $row[ 'name' ] ) ?>
                        </a>
                        <?php
                    }
                ?>
            </nav>
            <p>Все вакансии получены в виде <a href="https://rostrud.gov.ru/opendata/" rel="nofollow noopener noreferrer" target="_blank" tabindex="-1">открытых данных</a> из российской государственной информационной системы Федеральной службы по труду и занятости.</p>
            <blockquote>
                <p>Открытые данные - это информация, которая находится в свободном доступе в сети Интернет для использования без ограничений.</p>
            </blockquote>
            <h2>Некогда ходить на сайт?</h2>
            <p>Те же вакансии публикуются ещё в региональных каналах. Просто подпишитесь на интересующий канал ниже. Предложения о работе станут приходить на телефон.</p>
            <nav class="messengers">
                <h3>Телеграм:</h3>
                <?php
                    foreach ( $params as $row ) {
                        if ( $row[ 'tg_chat_id' ] ) {
                            ?>
                            <a class="btn" href="https://t.me/<?php printValue ( $row[ 'tg_chat_id' ] ) ?>" rel="nofollow noopener noreferrer" target="_blank">
                                <?php printValue ( $row[ 'chat_caption' ] ) ?>
                            </a>
                            <?php
                        }
                    }
                ?>
            </nav>
            <nav class="messengers">
                <h3>Max:</h3>
                <?php
                    foreach ( $params as $row ) {
                        if ( $row[ 'max_chat_id' ] ) {
                            ?>
                            <a class="btn" href="https://max.ru/<?php printValue ( $row[ 'max_chat_id' ] ) ?>" rel="nofollow noopener noreferrer" target="_blank">
                                <?php printValue ( $row[ 'chat_caption' ] ) ?>
                            </a>
                            <?php
                        }
                    }
                ?>
            </nav>
            <hr>
            <h2>Вы администратор?</h2>
            <p>Можете воспользоваться этими ссылками для выполнения задач по поддержке сайта.</p>
            <nav>
                <?php
                    if ( hasAdmin ( ) ) {
                        ?>
                        <a class="btn admin" href="tasks" rel="nofollow">
                            Задания для парсера
                        </a>
                        <a class="btn admin" href="settings" rel="nofollow">
                            Настройки сайта
                        </a>
                        <a class="btn admin" href="logout" rel="nofollow">
                            Выйти
                        </a>
                        <a class="btn secondary" href="password/change" rel="nofollow">
                            Сменить пароль
                        </a>
                        <?php
                    } else {
                        ?>
                        <a class="btn admin" href="login" rel="nofollow">
                            Войти
                        </a>
                        <?php
                    }
                ?>
            </nav>
            <?php
                mimimiModule ( 'snippets/demo-remark-2.tpl' );
                mimimiModule ( 'snippets/footer.tpl'        );
