/**
 * -------------------------------------------------------------------------
 *
 * Скрипты клиентской стороны сайта.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Repost Vacancies
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Отсчитать секундомер паузы, если такой элемент есть на странице.
     *
     * ---------------------------------------------------------------------
     */

    const STOPWATCH_GAP = 5;
    let   stopwatchInterval = 0;

    const incrementStopwatch = ( ) => {
        const nodes = document ?. querySelectorAll ( '.stopwatch[data-value]' );
        for ( let i = 0; i < nodes.length; i++ ) {
            let timer = parseInt ( nodes[ i ].getAttribute ( 'data-value' ) );
                timer = ( isNaN ( timer ) ? 1
                                          : timer ) - 1;
            nodes[ i ].setAttribute ( 'data-value', timer );
            if ( timer <= -STOPWATCH_GAP ) {
                clearInterval ( stopwatchInterval );
                window.location.reload ( );
                break;
            }
        }
    };

    stopwatchInterval = setInterval ( incrementStopwatch, 1000 );

    /**
     * ---------------------------------------------------------------------
     *
     * Снятие с форм ввода простейшей защиты от спам сканеров.
     *
     * ---------------------------------------------------------------------
     */

    const unlockForms = ( ) => {
        const nodes = document ?. querySelectorAll ( '.form:not(form)' );
        for ( let i = 0; i < nodes.length; i++ ) {
            nodes[ i ].setAttribute ( 'method', 'post' );
            const html = nodes[ i ].outerHTML;
            nodes[ i ].outerHTML = html.replace ( /^\s*<[^\s>]+/i,  '<form'   )
                                       .replace ( /<\/[^>]+>\s*$/i, '</form>' );
        }
    };

    unlockForms ( );
