<!DOCTYPE html>
<html lang="ru-RU">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="noindex, nofollow">
        <title>Парсер открытых данных</title>
        <meta name="description" content="Страница парсера, когда администратор на сайте.">
        <link rel="shortcut icon" href="<?php printThemeUrl () ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet" href="<?php printThemeUrl () ?>css/styles.css">
    </head>
    <body>
        <main>
            <h1>Парсинг</h1>
            <p>Результат работы текущего шага:</p>
            <ul class="report">
                <?php
                    foreach ( $params as $info ) {
                        ?>
                        <li><?php printValue ( $info ) ?></li>
                        <?php
                    }
                ?>
            </ul>
            <p>Следующий шаг будет выполнен автоматически через <span class="stopwatch" data-value="<?php
                                                                                                        printValue (
                                                                                                            $app->models->settings->get ( 'scan_pause' )
                                                                                                        )
                                                                                                    ?>"></span> секунд, если до того момента Вы всё ещё останетесь на этой странице.</p>
            <nav>
                <a class="btn" href="<?php printSiteUrl ( ) ?>">
                    Главная
                </a>
                <a class="btn admin" href="tasks" rel="nofollow">
                    Задания для парсера
                </a>
                <a class="btn admin" href="settings" rel="nofollow">
                    Настройка
                </a>
            </nav>
            <hr>
            <h2>Справка</h2>
            <p>Это пошаговый парсер, который запускается простым открытием его страницы, например вручную в браузере. Можно также делать запуск через крон, если вы имеете доступ к подобной функции хостинга и понимаете как выполняется настройка крона.</p>
            <p>Парсер извлекает открытые данные из Интернета через заданный интервал времени. Работа по извлечению, разбору и сохранению данных происходит согласно заданиям, установленным Вами в роли администратора сайта.</p>
            <?php
                mimimiModule ( 'snippets/footer.tpl' );
