<?php
/**
 * -------------------------------------------------------------------------
 *
 * Сниппет: Сгенерировать контент формы редактирования задания.
 *
 * -------------------------------------------------------------------------
 *
 * Входные параметры:
 *
 *     $app    = Указатель на объект Вашего приложения.
 *     $params = Данные от шаблона, вызвавшего этот сниппет.
 *               Представляют собой ассоциативный массив из таких элементов:
 *                   'success'     = Сообщение об успехе, если находимся в этот момент в демо-версии.
 *                   'error'       = Сообщение об ошибке, если какое-то поле оказалось заполненным неверно.
 *                   'button_name' = Значение атрибута "name" главной кнопки формы редактирования.
 *                   'structure'   = Структура полей задания.
 *                                   Смотрите её в методе getStructure() файла "repost.vacancies/Models/Tasks/Tasks.php".
 *                   'row'         = Запись редактируемого задания.
 *                                   Структуру записи смотрите в методе onInstall() файла "repost.vacancies/Models/Tasks/Tasks.php".
 *
 * -------------------------------------------------------------------------
 */

?>  <p class="success"><?php printValue ( $params[ 'success' ] ) ?></p>
    <p class="error"><?php   printValue ( $params[ 'error'   ] ) ?></p>
    <?php
        foreach ( $params[ 'structure' ] as $struct ) {
            $caption    = $struct[ 3 ];
            $name       = $struct[ 0 ];
            $value      = isset ( $params[ 'row' ][ $name ] ) ? $params[ 'row' ][ $name ]
                                                              : $struct[ 1 ];
            $type       = $struct[ 2 ];
            $attributes = $struct[ 4 ];
            switch ( $type ) {
                case 'textarea':
                     ?>
                     <label>
                         <span><?php           printValue ( $caption    ) ?>:</span>
                         <textarea name="<?php printValue ( $name       ) ?>"
                                   <?php       echo         $attributes   ?>><?php
                                               printValue ( $value      )
                         ?></textarea>
                     </label>
                     <?php
                     break;
                case 'select':
                     ?>
                     <label>
                         <span><?php         printValue ( $caption    ) ?>:</span>
                         <select name="<?php printValue ( $name       ) ?>"
                                   <?php     echo         $attributes   ?>>
                             <?php
                                 foreach ( $struct[ 1 ] as $name ) {
                                     $state = is_string ( $value ) && $name == $value ? 'selected'
                                                                                      : '';
                                     ?>
                                     <option <?php printValue ( $state ) ?>>
                                         <?php printValue ( $name ) ?>
                                     </option>
                                     <?php
                                 }
                             ?>
                         </select>
                     </label>
                     <?php
                     break;
                case 'number':
                case 'text':
                default:
                     ?>
                     <label>
                         <span><?php         printValue ( $caption    ) ?>:</span>
                         <input name="<?php  printValue ( $name       ) ?>"
                                value="<?php printValue ( $value      ) ?>"
                                type="<?php  printValue ( $type       ) ?>"
                                <?php        echo         $attributes   ?>>
                     </label>
                     <?php
            }
        }
    ?>
    <input name="id"
           value="<?php printValue ( $params[ 'row' ][ 'id' ] ) ?>"
           type="hidden">
