<b><?php printValue ( $params[ 'vacancyName' ] ) ?></b>

<blockquote><b>Зарплата:</b>
<?php
    $min = intval ( preg_replace ( '~\s~u', '', $params[ 'salaryMin' ] ) );
    $max = intval ( preg_replace ( '~\s~u', '', $params[ 'salaryMax' ] ) );
    $min = $min <= 0 ? $max
                     : $min;
    $max = $max <= 0 ? $min
                     : $max;
    $min = preg_replace ( '~(\d)(\d\d\d)$~u', '$1 $2', $min );
    $max = preg_replace ( '~(\d)(\d\d\d)$~u', '$1 $2', $max );
    if ( $min == $max ) {
        printValue ( $min );
    } else {
        printValue ( 'от ' . $min . "\nдо " . $max );
    }
?> рублей</blockquote>

<?php
   printForTelegram ( 'Организация:', $params, 'fullCompanyName' );
?>

<?php
    printForTelegram ( 'Адрес:', $params, 'fullAddress'                  );
    printForTelegram ( '',       $params, 'vacancyAddressAdditionalInfo' );
?>

<?php
    printForTelegram ( 'Расписание:',          $params[ 'workScheduleType' ], 'name'                    );
    printForTelegram ( "\nТип:",               $params,                       'busyType'                );
    printForTelegram ( "\nНачало дня:",        $params,                       'startWorking',       ' ' );
    printForTelegram ( 'Конец дня:',           $params,                       'endWorking',         ' ' );
    printForTelegram ( "\nОпыт работы (лет):", $params,                       'requiredExperience', ' ' );
    printForTelegram ( "\nБонус:",             $params,                       'bonusType'               );
?>

<?php
    printForTelegram ( 'Детали:', $params, 'additionalRequirements' );
?>

<?php
    printForTelegram ( 'Образование:',     $params,                      'educationType'       );
    printForTelegram ( "\nСпециализация:", $params,                      'educationSpeciality' );
    printForTelegram ( "\nПрофессия:",     $params,                      'profession'          );
    printForTelegram ( "\nКвалификация:",  $params,                      'qualification'       );
    printForTelegram ( "\nДокументы:",     $params[ 'medicalDocument' ], 'text'                );
?>

<?php
    printForTelegram ( 'Сертификаты:', $params, 'requiredCertificates' );
?>

<?php
    if ( $params[ 'requiredDriveLicense' ] ) {
        $num    = 1;
        $label  = 'Права водителя:';
        $margin = "\n" . $num . '. ';
        foreach ( $params[ 'requiredDriveLicense' ] as $key => $value ) {
            printForTelegram ( $label, $params[ 'requiredDriveLicense' ], $key, $margin );
            $num++;
            $label  = '';
            $margin = $num . '. ';
        }
    }
?>

<?php
    printForTelegram ( 'Задачи:', $params, 'positionResponsibilities' );
?>

<?php
    printForTelegram ( 'Требования:', $params, 'positionRequirements' );
?>

<?php
    if ( $params[ 'skills' ] ) {
        $num    = 1;
        $label  = 'Качества:';
        $margin = "\n" . $num . '. ';
        foreach ( $params[ 'skills' ] as $value ) {
            printForTelegram ( $label, $value, 'text', $margin );
            $num++;
            $label  = '';
            $margin = $num . '. ';
        }
    }
?>

<?php
    if ( $params[ 'benefits' ] ) {
        $num    = 1;
        $label  = 'Социальный пакет:';
        $margin = "\n" . $num . '. ';
        foreach ( $params[ 'benefits' ] as $key => $value ) {
            printForTelegram ( $label, $params[ 'benefits' ], $key, $margin );
            $num++;
            $label  = '';
            $margin = $num . '. ';
        }
        printForTelegram ( "\nОбучение (дней):", $params, 'trainingDays', ' ' );
    }
?>

<?php
    if ( $params[ 'socialProtected' ] ) {
        $num    = 1;
        $label  = 'Социальная защита:';
        $margin = "\n" . $num . '. ';
        foreach ( $params[ 'socialProtected' ] as $key => $value ) {
            printForTelegram ( $label, $params[ 'socialProtected' ], $key, $margin );
            $num++;
            $label  = '';
            $margin = $num . '. ';
        }
        printForTelegram ( "\nГруппа:", $params[ 'disabilityGroup' ], 'name', ' ' );
    }
?>

<?php
    printForTelegram ( 'Контакты:', $params, 'contactPerson' );
    foreach ( $params[ 'contacts' ] as $key => $value ) {
        printForTelegram ( '', $params[ 'contacts' ], $key, '' );
    }
?>

<?php
    $time  = substr ( $params[ 'publishedDate' ], 0, -3 );
    $day   = date ( 'd ',    $time );
    $month = date ( 'm',     $time ) - 1;
    $year  = date ( ' Y',    $time );
    $names = [ 'января'   ,
               'февраля'  ,
               'марта'    ,
               'апреля'   ,
               'мая'      ,
               'июня'     ,
               'июля'     ,
               'августа'  ,
               'сентября' ,
               'октября'  ,
               'ноября'   ,
               'декабря'  ];
    echo "<b>Опубликовано:</b>\n" . $day . $names[ $month ] . $year;
?>
