<?php
/**
 * -------------------------------------------------------------------------
 *
 * Модуль для представления, отправляющего данные в мессенджер Max.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Repost Vacancies
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Подключаем из папки ядра фреймворка файл "mimimi.core/Module.php".
     * Там объявлен класс "MimimiModule", являющийся простейшей модульной
     * заготовкой. Этот класс подходит как основа для реализуемого ниже
     * модуля.
     *
     * ---------------------------------------------------------------------
     */

    mimimiInclude ( 'Module.php' );

    /**
     * ---------------------------------------------------------------------
     *
     * Создаём на основе класса той заготовки новый класс, в котором напишем
     * программный код текущего модуля. Обратите внимание как задано имя
     * нового класса - оно сложено из имени класса вышестоящего модуля, то
     * есть "MyMimimiViews", и имени текущего PHP-файла без расширения.
     *
     * ---------------------------------------------------------------------
     */

    class MyMimimiViewsMax extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Опубликовать вакансию в канале.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            $token = $this->app->models->settings->get ( 'max_bot_token' );
            if ( $token ) {
                // заглушено так как мессенджер MAX
                // пока не предоставляет функционал
                // ботов частным лицам
            }
            return 0;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Удалить пост вакансии по её идентификатору.
         *
         * -----------------------------------------------------------------
         */

        public function remove ( $chat_id, $message_id ) {
            // заглушено так как мессенджер MAX
            // пока не предоставляет функционал
            // ботов частным лицам
        }
    }
