<?php
/**
 * -------------------------------------------------------------------------
 *
 * Модуль для хранителя представлений.
 *
 * -------------------------------------------------------------------------
 *
 * Данный модуль служит лишь для коллекционирования представлений в одной
 * папке, поэтому выполнен как обычная обёртка без собственных методов.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Repost Vacancies
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Подключаем из папки ядра фреймворка файл "mimimi.core/NodeModule.php".
     * Там объявлен класс "MimimiNodeModule", который является простейшей
     * заготовкой для модулей, поддерживающих дочерние, вызываемые через
     * оператор Стрелка. Этот класс подходит как основа для реализуемого
     * ниже модуля.
     *
     * ---------------------------------------------------------------------
     */

    mimimiInclude ( 'NodeModule.php' );

    /**
     * ---------------------------------------------------------------------
     *
     * Создаём на основе класса той заготовки новый класс, в котором напишем
     * программный код текущего модуля. Обратите внимание как задано имя
     * нового класса - оно сложено из системного префикса "MyMimimi", и имени
     * текущего PHP-файла без расширения.
     *
     * ---------------------------------------------------------------------
     */

    class MyMimimiViews extends MimimiNodeModule {

        /**
         * -----------------------------------------------------------------
         *
         * Инициализируем симулятор "неймспейса", так как в силу конструкции
         * класса "MimimiNodeModule" такое действие предписано совершать в
         * каждом наследуемом классе, если начиная с его узла тоже требуется
         * поддержать способность обращаться к его дочерним модулям через
         * оператор Стрелка (->).
         *
         * Как Вы можете видеть, в папке этого модуля находятся несколько
         * представлений: Html, Max, Telegram, к которым нам придётся
         * обращаться в любом случае. Поэтому мы и выполнили сейчас
         * инициализацию "неймспейса".
         *
         * Под неймспейсом понимается уникализация имён вложенных модульных
         * классов. Посмотрите как назван относительно текущего класса любой
         * класс дочернего модуля.
         *
         * -----------------------------------------------------------------
         *
         * @var    string
         * @access protected
         *
         * -----------------------------------------------------------------
         */

        protected $myNodeFile = __FILE__;
    }
