<?php
/**
 * -------------------------------------------------------------------------
 *
 * The module for working with page styles.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'DatabaseModule.php', FALSE );

    class MyMimimiDatabaseStyles extends MimimiDatabaseModule {

        /**
         * -----------------------------------------------------------------
         *
         * Returns the extension used for every style file in "database".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  string
         *
         * -----------------------------------------------------------------
         */

        public function getStorageExtension ( ) {
            return 'css';
        }

        /**
         * -----------------------------------------------------------------
         *
         * Returns the "database" path to store style files as a CSS files.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  string
         *
         * -----------------------------------------------------------------
         */

        public function getStoragePath ( ) {
            return MIMIMI_APP_FOLDER . 'Themes/' . MIMIMI_APP_THEME . '/css/pages/';
        }
    };
