<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the default Credits page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         ( );
    sendStatus200          ( );
    sendHeaderLastModified ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Is the current visitor an administrator? We get this boolean flag
     * exactly before generating the page content because the helperAmIAdmin()
     * routine algorithm implies sending server headers that can no longer
     * be sent if this routine is used inside content generation.
     *
     * ---------------------------------------------------------------------
     */

    $amIAdmin = helperAmIAdmin ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Gratitudes
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="index, follow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/credits.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content list">
                <div class="left">
                    <h1 class="title">
                        Credits
                    </h1>
                    <p>We would like to express our gratitude to third-party developers.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                        Home Page
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <h2>Third-party developers</h2>
                        <ol>
                            <li>
                                <p>Thanks to Mikael Ainalem for his idea for the animated form shown in codepen <a href="https://codepen.io/ainalem/pen/EQXjOR" rel="nofollow noopener noreferrer" target="_blank">Snake highlight</a>. This idea has been slightly reworked and adapted to different pages of this application.</p>
                            </li>
                            <li>
                                <p>Thanks to CKSource Holding for the self-hosted ZIP of <a href="https://ckeditor.com/ckeditor-5/download/" rel="nofollow noopener noreferrer" target="_blank">CKEditor 5</a> (ckeditor5-44.2.1.zip) that is licensed under the terms of GPL 2+. It was used as a built-in HTML editor to edit any page directly from the website interface.</p>
                            </li>
                            <li>
                                <p>Thanks to Josetxu for his codepen <a href="https://codepen.io/josetxu/pen/Poyygyg" rel="nofollow noopener noreferrer" target="_blank">Don Quixote - Pull Quotes - CSS</a>. This idea inspired me to transform it into an elegant page style <a href="styles/edit/don-quixote.css" rel="nofollow noopener noreferrer">dox-quixote.css</a> designed for literary sites.</p>
                            </li>
                            <li>
                                <p>Thanks to the Bootstrap Team for their powerful <a href="https://getbootstrap.com/docs/5.3/getting-started/download/" rel="nofollow noopener noreferrer" target="_blank">CSS framework</a>. It was used as one of the available stylesheets to create a static page. This page style is <a href="styles/edit/bootstrap.css" rel="nofollow noopener noreferrer">bootstrap.css</a>, which can be selected when an administrator starts editing the page.</p>
                            </li>
                            <li>
                                <p>Thanks to Montserrat.Git Project Authors for static <a href="https://github.com/JulietaUla/Montserrat.git" rel="nofollow noopener noreferrer" target="_blank">Montserrat</a> font that is licensed under the SIL Open Font License, Version 1.1. Montserrat was used as a base font for all pages of this application.</p>
                            </li>
                            <li>
                                <p>Thanks to MiMiMi for the small <a href="https://mimimi.software/" rel="nofollow noopener noreferrer" target="_blank">PHP framework</a> that is licensed under the terms of GPL 2. It was used to develop a lightweight engine for a website consisting of static pages that an administrator can freely edit.</p>
                            </li>
                        </ol>

                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Display administrator buttons.
                             *
                             * ---------------------------------------------
                             */

                            if ( $amIAdmin ) {
                                ?>
                                <h2>Do you know...</h2>
                                <p>This is the default page for expressing gratitude. But you can create a specific page instead. The app has a built-in HTML editor that makes such work easier.</p>
                                <a class="btn" href="<?php printSiteUrl ( ) ?>add/credits" rel="nofollow" title="Replace this page with your own">
                                    Replace Page
                                </a>
                                <?php
                            }
                        ?>
                    </div>
                </div>
            </main>

            <footer class="footnote"></footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/credits.js"></script>
    </body>
</html>
