<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the bbCode Blocks page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         (   );
    sendStatus200          (   );
    sendHeaderExpires      ( 0 );
    sendHeaderLastModified (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            bbCode Blocks
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex, nofollow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/bbcodes.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content list">
                <div class="left">
                    <h1 class="title">
                        bbCode Blocks
                    </h1>
                    <p>To add some dynamic features to a static page, this app provides the ability to edit the list of bbCode files.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                        Home Page
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <h2>bbCode Files</h2>
                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Collect all existing bbCode blocks.
                             *
                             * ---------------------------------------------
                             */

                            $files = helperCollectBBcodes ( );

                            /**
                             * ---------------------------------------------
                             *
                             * Define a local routine to display bbCode list.
                             *
                             * ---------------------------------------------
                             */

                            function localDisplayList ( $list, $level = 0 ) {
                                ?>
                                <ul>
                                    <?php
                                        foreach ( $list as $segment => & $url ) {
                                            ?>
                                            <li>
                                                <?php
                                                    /**
                                                     * ---------------------
                                                     *
                                                     * If it is a node.
                                                     *
                                                     * ---------------------
                                                     */

                                                    if ( is_array ( $url ) ) {
                                                        if ( isset ( $url[ '' ] ) ) {
                                                            $html = helperLoadBBcode (        $url[ '' ] );
                                                            $name = helperGetName    ( $html, $url[ '' ] );

                                                            ?>
                                                            <a href="<?php printSiteUrl (                              );
                                                                           printValue   ( 'bbcodes/edit/' . $url[ '' ] ) ?>" title="Edit this bbCode block" rel="nofollow">
                                                                <?php printValue ( $name ) ?>
                                                            </a>

                                                            <small class="tools">
                                                                &bullet; <a href="<?php printSiteUrl (                                );
                                                                                        printValue   ( 'bbcodes/upload/' . $url[ '' ] ) ?>" title="Replace this bbCode block with a new one" rel="nofollow">
                                                                             upload
                                                                         </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                                  );
                                                                                                             printValue   ( 'bbcodes/download/' . $url[ '' ] ) ?>" title="Download this bbCode as a TPL file" rel="nofollow">
                                                                                                  download
                                                                                              </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                              );
                                                                                                                                  printValue   ( 'bbcodes/copy/' . $url[ '' ] ) ?>" title="Clone this bbCode block" rel="nofollow">
                                                                                                                       copy
                                                                                                                   </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                                );
                                                                                                                                                       printValue   ( 'bbcodes/delete/' . $url[ '' ] ) ?>" title="Delete this bbCode block" rel="nofollow">
                                                                                                                                            delete
                                                                                                                                        </a>
                                                            </small>
                                                            <?php

                                                            unset ( $url[ '' ] );

                                                        /**
                                                         * ---------------------
                                                         *
                                                         * If it doesn't have
                                                         * a page with the same
                                                         * name.
                                                         *
                                                         * ---------------------
                                                         */

                                                        } else {
                                                            ?>
                                                            <span>
                                                                <?php printValue ( $segment ) ?>
                                                            </span>
                                                            <?php
                                                        }

                                                        /**
                                                         * ---------------------
                                                         *
                                                         * Display the subnodes
                                                         * of this branch.
                                                         *
                                                         * ---------------------
                                                         */

                                                        if ( $url ) {
                                                            localDisplayList ( $url, $level + 1 );
                                                        }

                                                    /**
                                                     * ---------------------
                                                     *
                                                     * Otherwise, it is the
                                                     * end of the branch.
                                                     *
                                                     * ---------------------
                                                     */

                                                    } else {
                                                        $src = $level ? $url
                                                                      : $segment;
                                                        $html = helperLoadBBcode (        $src     );
                                                        $name = helperGetName    ( $html, $segment );

                                                        ?>
                                                        <a href="<?php printSiteUrl (                        );
                                                                       printValue   ( 'bbcodes/edit/' . $src ) ?>" title="Edit this bbCode block" rel="nofollow">
                                                            <?php printValue ( $name ) ?>
                                                        </a>

                                                        <small class="tools">
                                                            &bullet; <a href="<?php printSiteUrl (                          );
                                                                                    printValue   ( 'bbcodes/upload/' . $src ) ?>" title="Replace this bbCode block with a new one" rel="nofollow">
                                                                         upload
                                                                     </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                            );
                                                                                                         printValue   ( 'bbcodes/download/' . $src ) ?>" title="Download this bbCode as a TPL file" rel="nofollow">
                                                                                              download
                                                                                          </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                        );
                                                                                                                              printValue   ( 'bbcodes/copy/' . $src ) ?>" title="Clone this bbCode block" rel="nofollow">
                                                                                                                   copy
                                                                                                               </a> &nbsp; &bullet; <a href="<?php printSiteUrl (                          );
                                                                                                                                                   printValue   ( 'bbcodes/delete/' . $src ) ?>" title="Delete this bbCode block" rel="nofollow">
                                                                                                                                        delete
                                                                                                                                    </a>
                                                        </small>
                                                        <?php
                                                    }
                                                ?>
                                            </li>
                                            <?php
                                        }
                                    ?>
                                </ul>
                                <?php
                            }

                            /**
                             * ---------------------------------------------
                             *
                             * Display collected bbCodes as a UL list.
                             *
                             * ---------------------------------------------
                             */

                            localDisplayList ( $files );
                        ?>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>bbcodes/add" rel="nofollow" title="Add a new bbCode block">
                            Add New
                        </a>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>bbcodes/upload" rel="nofollow" title="Upload a new bbCode block">
                            Upload New
                        </a>

                        <br>
                        <br>
                        <h2>Do you know...</h2>
                        <p>BBCode (bulletin board code) is a markup language introduced in 1998 to format messages on bulletin boards and forums. It has tags similar to HTML tags, but they are enclosed in square brackets surrounding a keyword that can have optional attributes.</p>
                        <p>Since your application already edits pages in HTML markup, it ignores all BBCode tags except one. This one is the <code>[insert=some-bbcode-file.tpl]</code> tag, which is used to insert a specified TPL file into the page.</p>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <a class="tool" href="<?php printSiteUrl ( ) ?>pages" rel="nofollow" title="Manage pages">
                    Pages
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>styles" rel="nofollow" title="Manage page styles">
                    Styles
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>fragments" rel="nofollow" title="Manage Page Constructor blocks">
                    Fragments
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/bbcodes.js"></script>
    </body>
</html>
