/**
 * -------------------------------------------------------------------------
 *
 * The frontend scripts for the Edit/Add page.
 *
 * -------------------------------------------------------------------------
 *
 * If you need some JavaScript logic on this page, it can be written below.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    import ( './login.js' );

    /**
     * ---------------------------------------------------------------------
     *
     * To handle the CSS changing.
     *
     * ---------------------------------------------------------------------
     */

    const changeCSS = ( ) => {
        const node = document.querySelector ( '.form select[name="css"]' );
        if ( node ) {
            node.addEventListener ( 'change', ( evt ) => {
                const attr = 'data-path',
                      tag  = document.querySelector ( 'html > head #stylesheet-tag[' + attr + ']' );
                if ( tag ) {
                    const path = tag.getAttribute ( attr ),
                          url  = path + evt.target.value;
                    tag.href = url;
                }
            } );
        }
    };

    setTimeout ( changeCSS, 100 );

    /**
     * ---------------------------------------------------------------------
     *
     * To generate a new URL.
     *
     * ---------------------------------------------------------------------
     */

    const generateUrl = ( btn, len = 10, segments = 2 ) => {
        const label = btn.closest ( 'label' );
        if ( label ) {
            const input = label.querySelector ( 'input[type="text"]' );
            if ( input ) {
                let code,
                    char,
                    url = '';
                while ( segments > 0 ) {
                    for ( let i = 0; i < len; i++ ) {
                        code = 48 + Math.random ( ) * ( 10 + 26 );
                        if ( code > 58 ) code += 39;
                        char = String.fromCharCode ( code );
                        url += char;
                    }
                    segments--;
                    if ( segments ) url += '/';
                };
                input.value = url;
            }
        }
    };

    /**
     * ---------------------------------------------------------------------
     *
     * To get the content of a built-in HTML editor or constructor.
     *
     * ---------------------------------------------------------------------
     */

    const getEditorContent = ( btn ) => {
        const form = btn.closest ( '.form' );
        if ( form ) {
            const input = form.querySelector ( 'input[name="body"][type="hidden"]' );
            if ( input ) {
                let html;
                if ( typeof window.editor == 'object' ) {
                    html = window.editor.getData ( ).replace ( /(<\/?)safe_/gi,                                        '$1'   )
                                                    .replace ( /<\/(!?doctype|meta|link|object|embed|applet)>/gi,      ''     )
                                                    .replace ( /(<[a-z][^>]*?[\s="'\/])safe_((on[a-z0-9_]*|href)[\s=\/>])/gi, '$1$2' );
                } else {
                    const construction = form.querySelector ( 'main.left' );
                    html = construction ? getRawHtml ( construction )
                                        : '';
                }
                input.value = html;
            }
        }
    };

    /**
     * ---------------------------------------------------------------------
     *
     * To close a modal dialog.
     *
     * ---------------------------------------------------------------------
     */

    const closeModalWindow = ( btn ) => {
        event.preventDefault ( );
        const dialog = btn.closest ( '.modal-window' );
        if ( dialog ) {
            dialog.close ( );
            if ( typeof needActiveBlock == 'function' ) {
                needActiveBlock ( );
            }
        }
    };
