/**
 * -------------------------------------------------------------------------
 *
 * The frontend scripts for the Log In page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    var current = null;

    /**
     * ---------------------------------------------------------------------
     *
     * To protect the input form.
     *
     * ---------------------------------------------------------------------
     */

    const secureForm = ( ) => {
        const nodes = document.querySelectorAll ( '.form button[name="submit"],' +
                                                  '.form button[name="submit2"],' +
                                                  '.form button[name="submit3"]' );
        if ( nodes ) {
            const form = nodes[ 0 ].closest ( '.form' );
            if ( form.tagName != 'FORM' ) {
                for ( let i = 0; i < nodes.length; i++ ) {
                    nodes[ i ].setAttribute ( 'value', 1 );
                }
                form.setAttribute ( 'method', 'post' );
                const html = form.outerHTML;
                form.outerHTML = html.replace ( /^\s*<div\s/i,  '<form '  )
                                     .replace ( /<\/div>\s*$/i, '</form>' );
            }
        }
    };

    secureForm ( );

    /**
     * ---------------------------------------------------------------------
     *
     * These functions are only declared if the AnimeJS script has been
     * loaded successfully. This simple check is necessary because the
     * "login.js" file can be imported into the javascript body of another
     * page using the import() directive where the AnimeJS script is not
     * used at all.
     *
     * ---------------------------------------------------------------------
     */

    if ( typeof anime == 'function' ) {

        /**
         * -----------------------------------------------------------------
         *
         * To animate the form first input field.
         *
         * -----------------------------------------------------------------
         */

        const snakeLogin = ( e ) => {
            if ( current ) current.pause ( );
            current = anime ({
                targets: 'path',
                strokeDashoffset: {
                    value:    0,
                    duration: 700,
                    easing:   'easeOutQuart' },
                strokeDasharray: {
                    value:    '240 1386',
                    duration: 700,
                    easing:   'easeOutQuart' }
            });
        };

        const loginNode = document.querySelector ( 'input[name="login"], input[name="url"]' );
        if ( loginNode ) {
              loginNode.addEventListener ( 'focus',       snakeLogin );
              loginNode.addEventListener ( 'pointerdown', snakeLogin );
              loginNode.addEventListener ( 'mouseover',   snakeLogin );
        }

        /**
         * -----------------------------------------------------------------
         *
         * To animate the form second input field.
         *
         * -----------------------------------------------------------------
         */

        const snakePass = ( e ) => {
            if ( current ) current.pause ( );
            current = anime ({
                targets: 'path',
                strokeDashoffset: {
                    value:    -336,
                    duration: 700,
                    easing:   'easeOutQuart' },
                strokeDasharray: {
                    value:    '240 1386',
                    duration: 700,
                    easing:   'easeOutQuart' }
            });
        };

        const passNode = document.querySelector ( 'input[name="pass"], input[name="upload"]' );
        if ( passNode ) {
              passNode.addEventListener ( 'focus',       snakePass );
              passNode.addEventListener ( 'pointerdown', snakePass );
              passNode.addEventListener ( 'mouseover',   snakePass );
        }

        /**
         * -----------------------------------------------------------------
         *
         * To animate the form button.
         *
         * -----------------------------------------------------------------
         */

        const snakeSubmit = ( e ) => {
            if ( current ) current.pause ( );
            current = anime ({
                targets: 'path',
                strokeDashoffset: {
                    value:    -730,
                    duration: 700,
                    easing:   'easeOutQuart' },
                strokeDasharray: {
                    value:    '530 1386',
                    duration: 700,
                    easing:   'easeOutQuart' }
            });
        };

        const submitNode = document.querySelector ( 'button[name="submit"]' );
        if ( submitNode ) {
              submitNode.addEventListener ( 'focus',       snakeSubmit );
              submitNode.addEventListener ( 'pointerdown', snakeSubmit );
              submitNode.addEventListener ( 'mouseover',   snakeSubmit );
        }
    }
