<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the Static page.
 *
 * -------------------------------------------------------------------------
 *
 * Input parameters are:
 *
 *     $params = HTML content of this page.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         ( );
    sendStatus200          ( );
    sendHeaderLastModified ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Is the current visitor an administrator? We get this boolean flag
     * exactly before generating the page content because the helperAmIAdmin()
     * routine algorithm implies sending server headers that can no longer
     * be sent if this routine is used inside content generation.
     *
     * ---------------------------------------------------------------------
     */

    $amIAdmin = helperAmIAdmin ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            <?php helperPrintTitle ( $params ) ?>
        </title>

        <meta name="description" content="<?php helperPrintMeta ( $params ) ?>">
        <meta name="viewport"    content="width=device-width, initial-scale=1">
        <meta name="robots"      content="index, follow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/ui.css">
        <link rel="stylesheet"    href="<?php helperPrintStyleUrl ( $params ) ?>">

        <script src="<?php printThemeUrl ( ) ?>js/scripts-before.js"></script>
    </head>

    <body>
        <div class="wrapper">
            <main class="content">
                <?php helperEchoBody ( $params ) ?>
            </main>

            <footer class="footnote">
                <a href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                    Home
                </a>

                <a href="<?php printSiteUrl ( ) ?>toc" title="View the list of existing pages">
                    TOC
                </a>

                <?php
                    /**
                     * -----------------------------------------------------
                     *
                     * Display administrator buttons.
                     *
                     * -----------------------------------------------------
                     */

                    if ( $amIAdmin ) {
                        mimimiModule ([ 'snippets/editor-tools.tpl', $params ]);
                        ?>
                        <a class="tool" href="<?php printSiteUrl ( ) ?>settings" rel="nofollow" title="Edit site settings">
                            Settings
                        </a>
                        <?php
                    }
                ?>

                <a href="<?php printSiteUrl ( ) ?>credits" title="Gratitude to third-party developers">
                    Credits
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/page.js"></script>
        <script src="<?php printThemeUrl ( ) ?>js/scripts-after.js"></script>
    </body>
</html>
