<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the ROBOTS.TXT document.
 *
 * -------------------------------------------------------------------------
 *
 * How did this file run?
 *
 *     ├─> .htaccess
 *     └─> index.php
 *           ├─> tiny.news.feed/Config.php
 *           ├─> mimimi.core/Routines.php
 *           ├─> [MAKE THE $app GLOBAL VARIABLE]
 *           ├─> tiny.news.feed/Constants.php          ┌─<─ class mimimi.core/Module.php
 *           │                  ┌─<─ class mimimi.core/NodeModule.php
 *           └─> tiny.news.feed/Application.php
 *                              │    └─> run()                ┌─<─ class mimimi.core/Module.php
 *                              │         ├─> mimimi.core/Has/Has.php
 *                              │         │                         ┌─<─ class mimimi.core/Module.php
 *                              │         └─> tiny.news.feed/Router/Router.php
 *                              │                                      └─> run()
 *                              └─<─ method getViewers()                    ├─> [MAKE THE $item GLOBAL VARIABLE  ]
 *                                                                          ├─> [MAKE THE $items GLOBAL VARIABLE ]
 *                                                                          ├─> [MAKE THE $page GLOBAL VARIABLE  ]
 *                                                                          ├─> [MAKE THE $viewer GLOBAL VARIABLE]
 *                                                                          ├─> [MAKE THE $url GLOBAL VARIABLE   ]
 *                                                                          └─> findMe()                     ┌─<─ class mimimi.core/Module.php
 *                                                                                 └─> tiny.news.feed/Themes/Themes.php
 *                                                                                                              ├─> checkFor()                                                    ┌─<─ class mimimi.core/Module.php
 *                                                                                                              └─> render()                     ┌─<─ class mimimi.modules/Helper/Helper.php
 *                                                                                                                     ├─> tiny.news.feed/Helper/Helper.php                       ├─<─ routine sendHeaderTEXT()
 *                                                                                                                     │                                                          ├─<─ routine sendStatus200()
 *                                                                                                                     │                                                          ├─<─ routine sendHeaderExpires()
 *                                                                                                                     │                                                          ├─<─ routine sendHeaderLastModified()
 *                                                                                                                     │                                                          ├─<─ routine stopIfHead()
 *                                                                                                                     │                                                          ├─<─ routine printSiteUrl()
 *                                                                                                                     │                                                          ├─<─ routine printValue()
 *                                                                                                                     │                                                          └─<─ routine printDomainUrl()
 *                                                                                                                     └─> tiny.news.feed/Themes/default/robots.tpl
 *                                                                                                                                                         └─> [SEND CONTENT TO THE BROWSER]
 *
 * The down-right arrows show the order in which app files are loaded and
 * their methods that are called when processing a request to the site.
 * The left-down arrows show the classes from which the corresponding
 * application file is derived. The left-up arrows show some of the public
 * routines or some of the public methods that the corresponding file
 * exposes to other application modules.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = FALSE        ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = FALSE        ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = 0            ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = ''           ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = 'robots.txt' ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $app      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderTEXT();                                   // it is text document           ( see file mimimi.modules/Helper/Helper.php -> sendHeaderTEXT )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(0);                               // cache will expire immediately ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
    sendHeaderLastModified();                           // last modified time equals now ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Text content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

?>
User-agent: *                                           # who can crawl pages on this site
Clean-param: utm                                        # remove duplicate pages with any UTM parameters
<?php                                                   // -----------------
    $list = $app->getViewers(                           // get a list of viewer names ( see file tiny.news.feed/Application.php -> getViewers )
                '*-sitemap.tpl'                         // . . which have a template for site map
            );                                          //
    if ( $list ) {                                      // if it is non-empty
        foreach ( $list as $name ) {                    //     walk through the provided list
            ?>Sitemap: <?php printSiteUrl();            //         print a site URL         ( like "htpps://your.site/" )
                             printValue($name);         //                 plus viewer name ( like "news"               )
                             ?>/sitemap                 # map for pages of specific type
<?php                                                   //
        }                                               //
    }                                                   // -----------------
?>
Host:    <?php printDomainUrl() ?>                      # main mirror of this site
