<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the website header.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $viewer = name of the current viewer ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *
 * And these system variables:
 *
 *     $params   = FALSE or last breadcrumb node name        ( see file    tiny.news.feed/Themes/default/home.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-list.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-page.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-add.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-delete.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-edit.tpl
 *                                                             or see file tiny.news.feed/Themes/default/404.tpl )
 *     $app      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $list = $app->getViewers(                           // get a list of viewer names      ( see file tiny.news.feed/Application.php -> getViewers )
                '*-list.tpl'                            // . . which have a template for listing
            );                                          //
                                                        // -----------------
    global $viewer;                                     // refer to the incoming variable
    $node = tinyGetBreadcrumb($viewer);                 // get a breadcrumb node name ( see file tiny.news.feed/Helper/Helper.php -> tinyGetBreadcrumb )
    $home = tinyGetBreadcrumb();                        // get a home node name       ( see file tiny.news.feed/Helper/Helper.php -> tinyGetBreadcrumb )
                                                        // -----------------

    /**
     * ---------------------------------------------------------------------
     *
     * The first breadcrumb node.
     *
     * ---------------------------------------------------------------------
     */

?>
<header class="header">
    <a class="logo" href="<?php printSiteUrl() ?>">
        <?php printValue(TINYFEED_INTERFACE_LOGO) ?>
    </a>

    <!-- ---------------------------------------
    *                                          *
    * The middle breadcrumb node.              *
    *                                          *
    ---------------------------------------- -->

    <details class="breadcrumbs middle">
        <summary class="switch">
            <?php printValue($node) ?>
        </summary>
        <nav class="menu">
            <a href="<?php printSiteUrl() ?>">
                <?php printValue($home) ?>
            </a>
            <?php                                       // -----------------
                if ( $list ) {                          // if viewers list is non-empty
                    foreach ( $list as $name ) {        //     walk through the provided list
                        $node = tinyGetBreadcrumb(      //         get a node name ( see file tiny.news.feed/Helper/Helper.php -> tinyGetBreadcrumb )
                                    $name               //         . . for this viewer name
                                );                      //
                        $root = [ 'url' => $name ];     //         make pseudo record for the root of that viewer list
                        ?>
                        <a href="<?php tinyPrintUrl($root) ?>">
                            <?php printValue($node) ?>
                        </a>
                        <?php                           //
                    }                                   //
                }                                       // -----------------
            ?>
        </nav>
    </details>
    <?php

        /**
         * -----------------------------------------------------------------
         *
         * The last breadcrumb node.
         *
         * -----------------------------------------------------------------
         */

                                                        // -----------------
        $ok = is_string($params);                       // check for last breadcrumb name
        if ( $ok ) {                                    // if it exists
            ?>
            <details class="breadcrumbs last" tabindex="-1">
                <summary class="switch">
                    <?php printValue($params) ?>
                </summary>
            </details>
            <?php                                       //
        }                                               // -----------------
    ?>
</header>
