<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a page to order products currently in the cart.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app = your application
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Check if the cart form is published and validate its items.
     *
     * ---------------------------------------------------------------------
     */

    $success   = '';

    $posted    = 0;
    $missing   = 0;
    $enough    = [ ];
    $notenough = [ ];
    $customer  = '';
    $delivery  = '';
    $url       = '';

    if ( getFormInput ( 'submit' ) ) {
        $customer = getFormInput ( 'customer' );
        $delivery = getFormInput ( 'delivery' );

        /**
         * -----------------------------------------------------------------
         *
         * Find each product in the cart.
         *
         * -----------------------------------------------------------------
         */

        $cart = mimimiPost ( 'products', [ ] );
        foreach ( $cart as $id => $count ) {
            $posted++;

            $entry = $app->vendors->getProduct ( $id );
            if ( ! $entry ) {
                $missing++;
            } else {

                /**
                 * ---------------------------------------------------------
                 *
                 * Check if you have enough of this product in stock.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $entry[ 'amount' ] < 1
                ||   $entry[ 'amount' ] < $count ) {
                    $notenough[ ] = $entry;
                } else {

                    /**
                     * -----------------------------------------------------
                     *
                     * Take this product out of stock if we are currently in
                     * in production mode.
                     *
                     * -----------------------------------------------------
                     */

                    $entry[ 'count' ] = $count;
                    $enough[ ] = $entry;

                    if ( $app->onProduction ) {
                        $row = [
                            'amount' => $entry[ 'amount' ] - $count
                        ];
                        $app->vendors->products->update ( $id, $row );
                    }
                }
            }
        }

        /**
         * -----------------------------------------------------------------
         *
         * Save order if there are successfully ordered products.
         *
         * -----------------------------------------------------------------
         */

        if ( $enough ) {
            if ( $app->onProduction ) {
                $cid  = getFormInput   ( 'customer_id' );
                $url  = mimimiRandomId ( 20            );
                $date = date           ( 'Y-m-d H:i:s' );
                foreach ( $enough as $entry ) {
                    $row = [
                        'customer_id' => $cid,
                        'customer'    => $customer,
                        'address'     => $delivery,
                        'product_id'  => $entry[ 'id'    ],
                        'vendor'      => $entry[ 'brand' ],
                        'product'     => $entry[ 'name'  ],
                        'cost'        => $entry[ 'price' ],
                        'count'       => $entry[ 'count' ],
                        'url'         => $url,
                        'date'        => $date
                    ];
                    $app->orders->add ( $row );
                }

                /**
                 * ---------------------------------------------------------
                 *
                 * Redirect to the order page (307 = temporary, not cached)
                 * if no products that are not enough.
                 *
                 * ---------------------------------------------------------
                 */

                $url = 'order/' . $url;
                if ( ! $notenough ) {
                    $url = printSiteUrl ( FALSE ) . $url;
                    mimimiStop ( $url, 307 );
                }
            }

            $success = 'Everything is fine! However, this website did not save your changes because you are currently in demo mode. In this mode, any addition/change/deletion of pages is simply simulated to show you how it would work on a real site.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML    (   );
    sendStatus200     (   );
    sendHeaderExpires ( 0 );
    stopIfHead        (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en-US">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/reset.min.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fonts.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">

        <meta name="robots" content="noindex, nofollow">
        <title>
            Order Products
        </title>
    </head>

    <body>
        <div class="wrapper">
            <div class="screen">
                <div class="app-bar">
                    <small data-label="Buyer: "><?php    printValue ( $customer ) ?></small>
                    <small data-label="Delivery: "><?php printValue ( $delivery ) ?></small>
                </div>

                <h1 class="title">
                    Latest Order
                    <a href="<?php printValue ( $url ) ?>" rel="nofollow">
                        here is your link to it &raquo;
                    </a>
                </h1>

                <div class="shop-items">
                    <?php

                        /**
                         * -------------------------------------------------
                         *
                         * If this page was accessed not from the cart form.
                         *
                         * -------------------------------------------------
                         */

                        if ( ! $posted ) {
                            ?>
                            <div class="item">
                                <div class="item-block">
                                    <p class="description">Whoops! Sorry, something went wrong and you ended up on a page that is not intended to be visited directly.</p>
                            
                                    <nav class="bottom-area hr">
                                        <div class="price">&nbsp;</div>
                                        <a class="button" href="<?php printSiteUrl ( ) ?>">
                                            <p>GO TO HOME</p>
                                        </a>
                                    </nav>
                                </div>
                            </div>
                            <?php
                        } else {

                            /**
                             * ---------------------------------------------
                             *
                             * If there are successfully ordered products.
                             *
                             * ---------------------------------------------
                             */

                            if ( $enough ) {
                                ?>
                                <div class="item">
                                    <div class="item-block">
                                        <p class="description success"><?php printValue ( $success ) ?></p>
                                        <p class="description">Okey! You have just ordered the following items:</p>

                                        <?php
                                            foreach ( $enough as $entry ) {
                                                $id = $entry[ 'id' ];
                                                ?>
                                                <h2 class="name tr">
                                                    <small><?php printValue ( $entry[ 'brand' ] ) ?></small>
                                                    <?php        printValue ( $entry[ 'name'  ] ) ?>
                                                </h2>
                                                <nav class="bottom-area">
                                                    <div class="price">&nbsp;</div>
                                                    <div class="amount"><?php printValue ( $cart[ $id ] ) ?></div>
                                                </nav>
                                                <?php
                                            }
                                        ?>
                            
                                        <nav class="bottom-area hr">
                                            <div class="price">&nbsp;</div>
                                            <a class="button" href="<?php printSiteUrl ( ) ?>">
                                                <p>GO TO HOME</p>
                                            </a>
                                        </nav>
                                    </div>
                                </div>
                                <?php
                            }

                            /**
                             * ---------------------------------------------
                             *
                             * If some products are not enough.
                             *
                             * ---------------------------------------------
                             */

                            if ( $notenough ) {
                                ?>
                                <div class="item">
                                    <div class="item-block">
                                        <p class="description error">Unfortunately, the following items are currently out of stock or in less quantity than you ordered:</p>

                                        <?php
                                            foreach ( $notenough as $entry ) {
                                                $id = $entry[ 'id' ];
                                                ?>
                                                <h2 class="name gray tr">
                                                    <small><?php printValue ( $entry[ 'brand' ] ) ?></small>
                                                    <?php        printValue ( $entry[ 'name'  ] ) ?>
                                                </h2>
                                                <nav class="bottom-area">
                                                    <div class="price">&nbsp;</div>
                                                    <div class="amount gray"><?php printValue ( $cart[ $id ] ) ?></div>
                                                </nav>
                                                <?php
                                            }
                                        ?>
                            
                                        <nav class="bottom-area hr">
                                            <div class="price">&nbsp;</div>
                                            <a class="button" href="<?php printSiteUrl ( ) ?>">
                                                <p>GO TO HOME</p>
                                            </a>
                                        </nav>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                    ?>
                </div>
            </div>
        </div>
    </body>
</html>