<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a page to delete a vendor.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app    = your application
 *     $params = database entry retrieved by the "Vendors" module
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute server logic according to this page type.
     *
     * ---------------------------------------------------------------------
     */

    $error   = '';
    $success = '';

    if ( getFormInput ( 'submit' ) ) {
        if ( getFormInput ( 'sure' ) ) {
            if ( $app->onProduction ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * Remove the vendor product entries and photos.
                 *
                 * ---------------------------------------------------------
                 */

                $list = $app->vendors->getProducts ( $params[ 'url' ] );
                if ( $list ) {
                    $app->vendors->removeProducts  ( $params[ 'url' ] );
                    foreach ( $list as $entry ) {
                        removeMedia ( $entry[ 'image' ] );
                    }
                }

                /**
                 * ---------------------------------------------------------
                 *
                 * Remove the vendor entry and its logo image.
                 *
                 * ---------------------------------------------------------
                 */

                $app->vendors->remove ( $params[ 'id'   ] );
                removeMedia           ( $params[ 'logo' ] );

                /**
                 * ---------------------------------------------------------
                 *
                 * Redirect to the home page.
                 *
                 * ---------------------------------------------------------
                 */

                $url = printSiteUrl ( FALSE );
                mimimiStop ( $url, 307 );

            /**
             * -------------------------------------------------------------
             *
             * Otherwise, prepare an error message.
             *
             * -------------------------------------------------------------
             */

            } else {
                $success = 'Everything is fine! However, this website did not save your changes because you are currently in demo mode. In this mode, any addition/change/deletion of pages is simply simulated to show you how it would work on a real site.';
            }
        } else {
            $error = 'Please confirm your wish by checking the "Yes, I am sure" box below.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML    (   );
    sendStatus200     (   );
    sendHeaderExpires ( 0 );
    stopIfHead        (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en-US">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/reset.min.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fonts.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">

        <meta name="robots" content="noindex, nofollow">
        <title>
            Deleting <?php printValue ( $params[ 'brand' ] ) ?>
        </title>
    </head>

    <body>
        <div class="wrapper">
            <div class="screen">
                <div class="app-bar">
                    <div class="bottom-area">
                        <div class="price">
                            <img class="logo" src="<?php printValue ( $params[ 'logo' ] ) ?>" loading="lazy" alt="">
                        </div>
                        <a class="button" href="<?php printSiteUrl ( ) ?>">
                            <p>GO TO HOME</p>
                        </a>
                    </div>
                </div>

                <h1 class="title">
                    <?php printValue ( $params[ 'brand' ] ) ?>
                    <small>Do you want to delete it?</small>
                </h1>

                <form class="shop-items" method="post">
                    <div class="item">
                        <div class="item-block">
                            <p class="description error"><?php   printValue ( $error            ) ?></p>
                            <p class="description success"><?php printValue ( $success          ) ?></p>

                            <p class="description"><?php         printValue ( $params[ 'meta' ] ) ?></p>

                            <legend class="center hr">
                                <label>
                                    <input name="sure" value="1" type="checkbox"> Yes, I am sure
                                </label>
                            </legend>

                            <nav class="bottom-area">
                                <div class="price">&nbsp;</div>
                                <button class="button" type="submit" name="submit" value="1">
                                    <p>DELETE</p>
                                </button>
                            </nav>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </body>
</html>