<?php
/**
 * -------------------------------------------------------------------------
 *
 * The database submodule for selecting vendor products.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Shopping UI with Vue.js
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'ModuleWithTable.php' );
    class MyMimimiVendorsProducts extends MimimiModuleWithTable {

        /**
         * -----------------------------------------------------------------
         *
         * Specify a name of the database table to store vendor products.
         *
         * -----------------------------------------------------------------
         *
         * @access public
         * @var    string
         *
         * -----------------------------------------------------------------
         */

        public $table = 'vendors_products';

        /**
         * -----------------------------------------------------------------
         *
         * Define a database table structure.
         *
         * -----------------------------------------------------------------
         *
         * @access protected
         * @var    array
         *
         * -----------------------------------------------------------------
         */

        protected $tableFields = [
                      '`id`           BIGINT(20)     NOT NULL  AUTO_INCREMENT  COMMENT "product system identifier"',
                      '`vendor_id`    BIGINT(20)     NOT NULL                  COMMENT "vendor identifier"',
                      '`image`        VARCHAR(255)   NOT NULL                  COMMENT "image URL relative to the site URL"',
                      '`name`         VARCHAR(60)    NOT NULL                  COMMENT "product name"',
                      '`description`  VARCHAR(1024)  NOT NULL                  COMMENT "product text description"',
                      '`price`        FLOAT(11,2)    NOT NULL                  COMMENT "product price"',
                      '`amount`       INT(11)        NOT NULL                  COMMENT "stock amount"',
                      '`color`        VARCHAR(20)    NOT NULL                  COMMENT "background color if product image has transparency"'
                  ];

        /**
         * -----------------------------------------------------------------
         *
         * Define a list of table keys to speed up the database operations
         * related to vendor products.
         *
         * -----------------------------------------------------------------
         *
         * @access protected
         * @var    array
         *
         * -----------------------------------------------------------------
         */

        protected $tableKeys = [
                      'PRIMARY KEY ( `id`        )',
                      'KEY         ( `vendor_id` )',
                      'KEY         ( `name`      )'
                  ];

        /**
         * -----------------------------------------------------------------
         *
         * Specify demo rows that will be used as default vendor product
         * entries if the database does not have a secondary table named
         * "vendors_products". In this case, all demo rows will be added to
         * the newly created secondary table.
         *
         * -----------------------------------------------------------------
         *
         * @access protected
         * @var    array
         *
         * -----------------------------------------------------------------
         */

        protected $demoRows = [
            [
                'id'          => 1,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-1.png',
                'name'        => 'Air Zoom Pegasus 36',
                'description' => 'The iconic Nike Air Zoom Pegasus 36 offers more cooling and mesh that targets breathability across high-heat areas. A slimmer heel collar and tongue reduce bulk, while exposed cables give you a snug fit at higher speeds.',
                'price'       => 108.97,
                'amount'      => 12,
                'color'       => '#e1e7ed'
            ], [
                'id'          => 2,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-2.png',
                'name'        => 'Air Zoom Pegasus 36 Shield',
                'description' => 'The Nike Air Zoom Pegasus 36 Shield gets updated to conquer wet routes. A water-repellent upper combines with an outsole that helps create grip on wet surfaces, letting you run in confidence despite the weather.',
                'price'       => 89.97,
                'amount'      => 5,
                'color'       => '#4D317F'
            ], [
                'id'          => 3,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-3.png',
                'name'        => 'CruzrOne',
                'description' => 'Designed for steady, easy-paced movement, the Nike CruzrOne keeps you going. Its rocker-shaped sole and plush, lightweight cushioning let you move naturally and comfortably. The padded collar is lined with soft wool, adding luxury to every step, while mesh details let your foot breathe. There’s no finish line—there’s only you, one step after the next.',
                'price'       => 100.97,
                'amount'      => 9,
                'color'       => '#E8D026'
            ], [
                'id'          => 4,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-4.png',
                'name'        => 'Epic React Flyknit 2',
                'description' => 'The Nike Epic React Flyknit 2 takes a step up from its predecessor with smooth, lightweight performance and a bold look. An updated Flyknit upper conforms to your foot with a minimal, supportive design. Underfoot, durable Nike React technology defies the odds by being both soft and responsive, for comfort that lasts as long as you can run.',
                'price'       => 89.97,
                'amount'      => 7,
                'color'       => '#FD584A'
            ], [
                'id'          => 5,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-5.png',
                'name'        => 'Odyssey React Flyknit 2',
                'description' => 'The Nike Odyssey React Flyknit 2 provides a strategic combination of lightweight Flyknit construction and synthetic material for support. Underfoot, Nike React cushioning delivers a soft, springy ride for a route that begs to be crushed.',
                'price'       => 71.97,
                'amount'      => 7,
                'color'       => '#D4D7D6'
            ], [
                'id'          => 6,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-6.png',
                'name'        => 'React Infinity Run Flyknit',
                'description' => 'A pioneer in the running shoe frontier honors the original pioneer of running culture with the Nike React Infinity Run Flyknit. Blue Ribbon Track Club-inspired details pay homage to the haven that was created before running was even popular. This running shoe is designed to help reduce injury and keep you on the run. More foam and improved upper details provide a secure and cushioned feel.',
                'price'       => 160.0,
                'amount'      => 0,
                'color'       => '#F2F5F4'
            ], [
                'id'          => 7,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-7.png',
                'name'        => 'React Miler',
                'description' => 'The Nike React Miler gives you trusted stability for miles with athlete-informed performance. Made for dependability on your long runs, its intuitive design offers a locked-in fit and a durable feel.',
                'price'       => 130.0,
                'amount'      => 2,
                'color'       => '#22AFDC'
            ], [
                'id'          => 8,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-8.png',
                'name'        => 'Renew Ride',
                'description' => 'The Nike Renew Ride helps keep the committed runner moving with plush cushioning. Firm support at the outsole helps you maintain stability no matter the distance.',
                'price'       => 60.97,
                'amount'      => 5,
                'color'       => '#B50320'
            ], [
                'id'          => 9,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-9.png',
                'name'        => 'Vaporfly 4% Flyknit',
                'description' => 'Built to meet the exacting needs of world-class marathoners, Nike Vaporfly 4% Flyknit is designed for record-breaking speed. The Flyknit upper delivers breathable support, while the responsive foam and full-length plate provide incredible energy return for all 26.2.',
                'price'       => 187.97,
                'amount'      => 5,
                'color'       => '#3569A1'
            ], [
                'id'          => 10,
                'vendor_id'   => 1,
                'image'       => 'media/demo-posts/vue.js.cart/nike-product-10.png',
                'name'        => 'Zoom Fly 3 Premium',
                'description' => 'Inspired by the Vaporfly, the Nike Zoom Fly 3 Premium gives distance runners race-day comfort and durability. The power of a carbon fiber plate keeps you in the running mile after mile.',
                'price'       => 160.0,
                'amount'      => 5,
                'color'       => '#54D4C9'
            ]
        ];
    };
